<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Visiosoft\TrendyolModule\IntegratedProduct\Form\CreateProductOnTrendyolFormBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Table\CustomIntegratedProductTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;

class IntegratedProductsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param IntegratedProductTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomIntegratedProductTableBuilder $table)
    {
        return $table->render();
    }

     // Select product to be integrated.

    public function select()
    {
        return $this->view->make(
            'visiosoft.module.trendyol::admin/trendyolIntegration/select'       
        );
    }

    // Create product on Trendyol. 

    public function create(CreateProductOnTrendyolFormBuilder $form, $oc_product_id)
    {
        return $form->render($oc_product_id);
    }

    public function edit(CreateProductOnTrendyolFormBuilder $form, $oc_product_id) {
        $integratedProducts = app(IntegratedProductRepository::class);

        if ($integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $oc_product_id)) {
            $trendyol_spesific_information = json_decode($integratedProductToBeUpdated['trendyol_spesific_information']);
            $barcode = $integratedProductToBeUpdated['barcode'];
        }

        $fields = $form->getFields();
        $fields['barcode']['value'] = $barcode;
        $fields['productMainId']['value'] = $trendyol_spesific_information->mainProductId;
        $fields['brand']['value'] = $trendyol_spesific_information->brandId;
        $fields['category']['value'] = $trendyol_spesific_information->categoryId;
        $fields['categoryAttributes']['value'] = json_encode($trendyol_spesific_information->attributes);
        $fields['stockCode']['value'] = $trendyol_spesific_information->stockCode;
        $fields['dimensionalWeight']['value'] = $trendyol_spesific_information->dimensionalWeight;
        $fields['cargoCompany']['value'] = $trendyol_spesific_information->cargoCompanyId;
        $fields['vatRate']['value'] = $trendyol_spesific_information->taxRate;
        $form->setFields($fields);
        
        return $form->render($oc_product_id);
    }
}
