<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;

class ApiRequestController extends AdminController
{
    public $endpoint;
    public $productPageUrlBase;
    protected $supplier_id;
    protected $api_username;
    protected $api_password;
    protected $user_agent;
    protected $auth_basic;
    public $is_testEnvironment;

    protected function getCredentialsForTrendyolApi()
    {
        $this->supplier_id = setting_value('visiosoft.module.trendyol::supplier_id');
        $this->api_username = setting_value('visiosoft.module.trendyol::API_username');
        $this->api_password = setting_value('visiosoft.module.trendyol::API_password');
        $this->user_agent = $this->supplier_id . ' - ' . 'SelfIntegration';
        $this->auth_basic = "Authorization: Basic ". base64_encode("$this->api_username:$this->api_password");
    }

    public function detectEndpoint()
    {
        $this->is_testEnvironment = setting_value('visiosoft.module.trendyol::test_environment_request'); 

        switch ($this->is_testEnvironment) {
            case true:
                $this->endpoint = setting_value('visiosoft.module.trendyol::test_environment_endpoint');
                $this->productPageUrlBase = setting_value('visiosoft.module.trendyol::product_url_base_test_environment');
                break;
            case false:
                $this->endpoint = setting_value('visiosoft.module.trendyol::product_environment_endpoint');
                $this->productPageUrlBase = setting_value('visiosoft.module.trendyol::product_url_base');
        }
    }

    public function returnProductInformation($requestedInformation, $filterData="", $messages="")
    {
        $this->getCredentialsForTrendyolApi();

        $this->detectEndpoint();

        $information;

        switch ($requestedInformation) {
            case 'brands':
              $information = $this->getProductInformation($this->endpoint . "brands/by-name?name=" . $filterData);
              break;
            case 'categories':
              $information = $this->getProductInformation($this->endpoint . "product-categories");
              break;
            case 'categoryAttributes':
              $information = $this->getProductInformation($this->endpoint . "product-categories/" . $filterData . "/attributes");
              break;
            case 'cargoCompanies':
              $information = $this->getProductInformation($this->endpoint . "shipment-providers");
              break;
            case 'resultOfSendRequest':
              $information = $this->getProductInformation($this->endpoint . 'suppliers/' . $this->supplier_id . '/products/batch-requests/' . $filterData, $messages);
              break;
            case 'createdProductOnTrendyol':
              $information = $this->getProductInformation($this->endpoint . 'suppliers/' . $this->supplier_id . '/products?barcode=' . $filterData);
              break;
            default:
              break;
        }

        if ($requestedInformation === 'resultOfSendRequest') {
            if ($messages->has('error')) {
                return;
            } else {
                return json_encode($information);
            }
        } else {
            return json_encode($information);
        }
    }

    protected function getProductInformation($relevantServiceUrl, $messages="")
    {
        $ch = curl_init();

        $options = array(
            CURLOPT_URL => $relevantServiceUrl,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPHEADER => [$this->auth_basic],
            CURLOPT_USERAGENT => $this->user_agent,
            CURLOPT_SSL_VERIFYPEER => false,
        );

        curl_setopt_array($ch, $options);

        $response = curl_exec($ch);

        $responseArray = json_decode($response,true);

        $err = curl_error($ch);

        if (stripos($relevantServiceUrl, 'batch')) {
            if ($err) {
                $messages->error('Curl error => ' . $err);
                return;
            } else if ($responseArray["failedItemCount"] > 0) {
                foreach ($responseArray['items'] as $itemArr) {
                    if ($itemArr["status"] === "FAILED") {
                        if (stripos(url()->previous(), 'edit_advs')) {
                            foreach ($itemArr['failureReasons'] as $failReason) {
                                $messages->error('Failed Item with barcode \'' . $itemArr["requestItem"]["barcode"] . 
                                '\'. Failure Reasons: ' . $failReason);
                            }
                        } else {
                            foreach ($itemArr['failureReasons'] as $failReason) {
                                $messages->error('Failed Item ' . '\'' . $itemArr['requestItem']['product']['title'] . '\' with number ' . $itemArr["requestItem"]["barcode"] . 
                                '. Failure Reasons: ' . $failReason);
                            }
                        }

                    }
                }
                return;
            } else {
                return json_decode($response,true);
            }   
        } else if ($err) {
            return ['error' => true];
        } else {
            if (stripos($relevantServiceUrl, 'barcode') && !(stripos(url()->previous(), 'edit'))) {
                $urlToProductPage = url($this->productPageUrlBase . $responseArray['content'][0]['id']);
                return redirect()->to($urlToProductPage)->send();
            }

            return json_decode($response,true);
        }
        
        curl_close($ch);
    }

    public function sendRequestToTrendyol($productInformation, $messages, $requestType)
    {
        $ch = curl_init();

        $options = array(
            CURLOPT_URL => $this->endpoint . 'suppliers/' . $this->supplier_id . ($requestType === "POST_UPDATE" ? '/products/price-and-inventory' : '/v2/products'),
            CURLOPT_CUSTOMREQUEST => $requestType === "PUT" ? "PUT" : "POST",
            CURLOPT_POSTFIELDS => json_encode($productInformation),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPHEADER => [$this->auth_basic, 'Content-Type: application/json'],
            CURLOPT_USERAGENT => $this->user_agent,
            CURLOPT_SSL_VERIFYPEER => false,
        );

        curl_setopt_array($ch, $options);

        $response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
            $messages->error('Curl error => ' . $err);
            return;
        } else if (curl_getinfo($ch, CURLINFO_HTTP_CODE) !== 200) {
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
            switch ($statusCode) {
                case 400:
                  $messages->error('Error: Missing or incorrect parameters have been used in the URL');
                  $responseObject = json_decode($response);
                  foreach ($responseObject->errors as $error) {
                      if (!(stripos(url()->previous(), 'edit'))) {
                        $messages->error('Error Detail: ' . $error->message);
                      } else {
                        $messages->error('Error!');
                      }
                  }
                  break;
                case 401:
                  $messages->error('One of the supplierID, API Key, API Secure Key information you used while sending the request is missing or incorrect. 
                  Please fill in the relevant form fields in the Trendyol Module settings of this site with the correct information. 
                  You can find the right information for your store on the Trendyol Seller Panel ');
                  break;
                case 404:
                  $messages->error('The url information which has been sent to the request is incorrect. Please refer to your software developer.');
                  break;
                case 500:
                  $messages->error('Maybe there has been momentary error or there is an error in the post request body. 
                  If your problem is not solved after trying a few times, please refer to your software developer.');
                  break;
                default:
                  $messages->error('Please refer to your software developer with status code: ' . $statusCode);
            }
            return;
        } else {
            $response = json_decode($response, true);
            return $response['batchRequestId'];
        }

        curl_close($ch);
    }
}