$(document).ready(function(){
    let cargoCompanyInputField = $("#cargoCompany");
    let myCargoCompanies = [];

    cargoCompanyInputField.after(
        `<div class="list-group" id="matched_companies"></div>`
    );

    cargoCompanyInputField.keyup(function() {
        if (cargoCompanyInputField.val().length === 0) {
            $("div#matched_companies").html(""); 
            $("div#matched_companies").hide();
            return;
        }
        $("div#matched_companies").show();
        let currentInput = cargoCompanyInputField.val();
        var options = {
            pre: '<', 
            post: '>', 
            extract: function(el) { return el.name; }
        };
        let results = fuzzy.filter(currentInput, myCargoCompanies, options);
        let matches = results.map(function(el) { return el.original; });

        $("div#matched_companies").html("");    
        matches.forEach(function(item, index, array) {
            $("#matched_companies").append(`
                <a href="#" id="${item.id}" class="list-group-item list-group-item-action cargoCompany-option">${item.name}</a>
            `);
        });
    });

    cargoCompanyInputField.blur(function(event) {
        if (!($(event.relatedTarget).attr('class') == "list-group-item list-group-item-action cargoCompany-option")) {
            $("div#matched_companies").hide();
        }
    });

    cargoCompanyInputField.focus(function() {
        if (cargoCompanyInputField.val().length >= 1) {
            $("div#matched_companies").show();
        }
    });

    $("div#matched_companies").on("click", "a", function(event) {
        event.preventDefault();
        cargoCompanyInputField.val($(this).attr('id') + ' - ' + $(this).text());
        $("div#matched_companies").html("");
        $("div#matched_companies").hide();
    });

    function getCargoCompanies() {
        $.ajax({
            url: `/admin/getProductInformation/cargoCompanies`,
            dataType: "json",
            success: function(cargoCompanies) {
                for (let company of cargoCompanies) {
                    myCargoCompanies.push(company);
                }
            }
        });
    }

    getCargoCompanies();
});