<?php namespace Visiosoft\TrendyolModule\IntegratedProduct\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductModel;

class CustomIntegratedProductTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'product_id',
        'trendyol_id',
        'trendyol_url' => [
            'wrapper' => '<a href="{value}" class="btn btn-warning">See on Trendyol</a>'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'created_at' => 'desc' 
        ],
        'table_view' => 'visiosoft.module.trendyol::admin/trendyolIntegration/table',
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

    protected $model = IntegratedProductModel::class;

}