<?php namespace Visiosoft\TrendyolModule\IntegratedProduct\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Form\Validator\TaxRatesValidator;

class CreateProductOnTrendyolFormBuilder extends FormBuilder
{
    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'barcode' => [
            'label' => 'visiosoft.module.trendyol::field.barcode.label',
            'instructions' => 'visiosoft.module.trendyol::field.barcode.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'rules' => [
                'not_regex:/^[?\/&%+^\'*_]/',
                'min:13',
            ]
        ],
        'productMainId' => [
            'label' => 'visiosoft.module.trendyol::field.productMainId.label',
            'instructions' => 'visiosoft.module.trendyol::field.productMainId.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
        ],
        'brand' => [
            'label' => 'visiosoft.module.trendyol::field.brand.label',
            'instructions' => 'visiosoft.module.trendyol::field.brand.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'config' => [
                'mode' => 'search'
            ],
        ],
        'category' => [
            'label' => 'visiosoft.module.trendyol::field.category.label',
            'instructions' => 'visiosoft.module.trendyol::field.category.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'config' => [
                'mode' => 'search',
            ],

        ],
        'categoryAttributes' => [
            'type' => 'visiosoft.field_type.json',
            'hidden' => true,
        ],
        'stockCode' => [
            'label' => 'visiosoft.module.trendyol::field.stockCode.label',
            'instructions' => 'visiosoft.module.trendyol::field.stockCode.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
        ],
        'dimensionalWeight' => [
            'label' => 'visiosoft.module.trendyol::field.dimensionalWeight.label',
            'instructions' => 'visiosoft.module.trendyol::field.dimensionalWeight.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'rules' => [
                'not_regex:/[a-zA-Z]/',
            ]

        ],
        'cargoCompany' => [
            'label' => 'visiosoft.module.trendyol::field.cargoCompany.label',
            'instructions' => 'visiosoft.module.trendyol::field.cargoCompany.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
        ],
        'vatRate' => [
            'label' => 'visiosoft.module.trendyol::field.vatRate.label',
            'instructions' => 'visiosoft.module.trendyol::field.vatRate.instructions',
            'type' => 'anomaly.field_type.integer',
            'required' => true,
            'rules' => [
                'taxRates_validators',
            ],
            'validators' => [
                'taxRates_validators' => [
                    'handler' => TaxRatesValidator::class,
                    'message' => 'You can only enter spesific tax rate\'s numerator'
                ],
            ]
        ],
        // 'shipmentAddressId',
        // 'returningAddressId',
        // deliveryDuration
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [
    ];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [
    ];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'send' => [
            'text' => 'visiosoft.module.trendyol::button.send.name',
        ]
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel' => [
            'text' => 'visiosoft.module.trendyol::button.cancel.name'
        ]
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => 'admin/trendyol/',
        'success_message' => false,
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    protected $handler = CreateProductOnTrendyolFormHandler::class;

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.trendyol::js/brand.js',
            'visiosoft.module.trendyol::js/category.js',
            'visiosoft.module.trendyol::js/cargoCompany.js',
            'visiosoft.module.trendyol::js/imageWarning.js',
            'visiosoft.module.trendyol::js/fuzzy.js',
            'visiosoft.module.trendyol::js/form.js',
            // 'visiosoft.module.trendyol::../node_modules/fuzzy/lib/fuzzy.js',
        ],
        'styles.css' => [
            'visiosoft.module.trendyol::css/main.css',
        ],
    ];

}
