$(document).ready(function() {
    function getProductImages() {
        var currentPathPartials = window.location.pathname.split('/');
        $.ajax({
            url: `/admin/getProductImages/${currentPathPartials[currentPathPartials.length - 1]}`,
            dataType: "json",
            success: function(images) {
                createWarningInUi(images);
            }
        });
    }

    let alertImage = document.createElement('div');
    alertImage.className = 'alert alert-warning';

    function createWarningInUi(images) {
        let problemImageNames = [];
        images.forEach(function(image, index, arr) {
            if (image.imageWidth != 1200 || image.imageHeight != 1800) {
                problemImageNames.push(images[index].imageUrl);
            }
        });

        if (problemImageNames.length > 1) {
            alertImage.innerHTML = `The images ${problemImageNames} of this product you want to create in Trendyol do not have valid dimensions (1200 x 1800). In this case, your product could be sent to Trendyol, but it would not have a picture and would not put up for sale. You can overcome this problem by deleting and reloading the relevant product images after making the \'full image width\', \'full image height\', \'Image Canvas Width\', \'Image Canvas Height\' fields from the settings section of the Adv module of our site to 1200 (width) to 1800 (height), or by uploading images in Trendyol. We recommend that you upload 1200x1800 sized photos.`;
            document.querySelectorAll('#buttons')[0].after(alertImage);
        } else if (problemImageNames.length == 1) {
            alertImage.innerHTML = `The image ${problemImageNames[0]} of this product you want to create in Trendyol do not have valid dimensions. In this case, your product could be sent to Trendyol, but it would not have a picture and would not put up for sale. You can overcome this problem by deleting and reloading the relevant product image after making the \'full image width\', \'full image height\', \'Image Canvas Width\', \'Image Canvas Height\' fields from the settings section of the Adv module of our site to 1200 (width) to 1800 (height), or by uploading image in Trendyol. We recommend that you upload 1200x1800 sized photos.`;
            document.querySelectorAll('#buttons')[0].after(alertImage);
        }
    }

    getProductImages();
});