<?php namespace Visiosoft\TranslatorModule\TableTranslator;

use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\TranslatorModule\TableTranslator\Contract\TableTranslatorRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TableTranslatorRepository extends EntryRepository implements TableTranslatorRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TableTranslatorModel
     */
    protected $model;
    protected $streamRepository;

    /**
     * Create a new TableTranslatorRepository instance.
     *
     * @param TableTranslatorModel $model
     */
    public function __construct(TableTranslatorModel $model, StreamRepositoryInterface $streamRepository)
    {
        $this->model = $model;
        $this->streamRepository = $streamRepository;
    }

    public function getTranslateTables()
    {
        $installed_modules = app('module.collection')->installed();
        $installed_extension = app('extension.collection')->installed();
        $installed_theme = app('theme.collection')->installed();
        $installed_plugin = app('plugin.collection')->installed();

        $installed_addons = $installed_modules->merge($installed_extension, $installed_theme, $installed_plugin);

        $translate_tables = array();
        foreach ($installed_addons as $addon) {
            $streams = $this->streamRepository->findAllByNamespace($addon->getSlug());
            foreach ($streams as $stream) {
                $table = $stream->getEntryTranslationsTableName();
                $translate_tables[$table] = $table;
            }
        }
        return $translate_tables;
    }

    public function translateGoogle($text, $source, $target)
    {
        $api_key = setting_value('visiosoft.module.translator::google_translate_api');
        $translate_api_url = setting_value('visiosoft.module.translator::google_translate_api_url');
        $url = $translate_api_url . '/?key=' . $api_key .
            '&q=' . rawurlencode($text) . '&source=' . $source . '&target=' . $target;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FAILONERROR, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 45);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $responseDecoded = curl_exec($ch);
        curl_close($ch);

        $responseDecoded = json_decode($responseDecoded, true);

        return $responseDecoded['data']['translations'][0]['translatedText'];
    }

}
