<?php namespace Visiosoft\TranslatorModule\TableTranslator\Form;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;
use Visiosoft\TranslatorModule\TableTranslator\Contract\TableTranslatorRepositoryInterface;
use Visiosoft\TranslatorModule\TableTranslator\Traits\getTranslateRecord;

class TableTranslatorFormHandler
{
    use getTranslateRecord;

    public function handle(TableTranslatorFormBuilder $builder, TableTranslatorRepositoryInterface $repository, Builder $query)
    {
        if (!$builder->canSave()) {
            return;
        }

        $table = $builder->getPostValue('table');
        $source = $builder->getPostValue('source');
        $target = $builder->getPostValue('target');

        $untranslated_columns = [
            'entry_id',
            'id',
            'created_at',
            'created_by_id',
            'updated_at',
            'updated_by_id',
            'locale'
        ];

        $rows = $this->getRecords($table, $target, $source);

        ini_set('max_execution_time', 0);

        foreach ($rows as $row) {
            $row = (array)$row;

            $translated_columns = array();
            foreach ($row as $column_name => $value) {

                if (!in_array($column_name, $untranslated_columns)) {

                    $translated = $repository->translateGoogle($value, $source, $target);

                    $translated_columns[$column_name] = $translated;
                }
            }

            $is_translated_row = DB::table($table)
                ->where('locale', $target)
                ->where('entry_id', $row['entry_id']);

            $update_query = clone $is_translated_row;

            if ($is_translated_row = $is_translated_row->first()) {
                if (!$is_translated_row->updated_at) {
                    $update_query->update($translated_columns);
                }
            } else {
                DB::table($table)->insert(array_merge([
                    'entry_id' => $row['entry_id'],
                    'locale' => $target,
                    'updated_at' => now()
                ], $translated_columns));
            }
        }
    }
}
