<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTranslatorCreateTableTranslatorStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'table_translator',
        'title_column' => 'table',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'table' => [
            'required' => true,
        ],
        'source' => [
            'required' => true,
        ],
        'target' => [
            'required' => true,
        ],
    ];

}
