<?php namespace Visiosoft\TranslatorModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;

/**
 * Class TranslatorModuleServiceProvider
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 * @package       Visiosoft\TranslatorModule
 */
class TranslatorModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @var array
     */
    protected $routes = [
        'admin/translator/{type?}'                          => 'Visiosoft\TranslatorModule\Http\Controller\Admin\AddonsController@index',
        'admin/translator/translations/{namespace}'         => 'Visiosoft\TranslatorModule\Http\Controller\Admin\TranslationsController@translations',
        'admin/translator/differences/{namespace}/{locale}' => 'Visiosoft\TranslatorModule\Http\Controller\Admin\TranslationsController@differences',
        'admin/translator/translate/{namespace}'            => 'Visiosoft\TranslatorModule\Http\Controller\Admin\TranslationsController@translate',
    ];
}
