<?php namespace Visiosoft\TranslatorModule\TableTranslator\Traits;

use Illuminate\Support\Facades\DB;

trait getTranslateRecord
{
    public function getRecords($table, $target, $source)
    {
        $rows_translated = DB::table($table)
            ->where('locale', $target)
            ->select('entry_id')
            ->pluck('entry_id')
            ->all();


        $rows = DB::table($table)
            ->where('locale', $source)
            ->whereNotIn('entry_id', $rows_translated)
            ->limit(5000)
            ->get();

        return $rows;
    }
}