<?php namespace Visiosoft\TranslatorModule\TableTranslator\Form;

use Visiosoft\TranslatorModule\TableTranslator\Contract\TableTranslatorRepositoryInterface;
use Visiosoft\TranslatorModule\TableTranslator\Form\Validation\ValidateRecord;

class TableTranslatorFormFields
{
    public function handle(TableTranslatorFormBuilder $builder)
    {
        $builder->setFields([
            'table' => [
                'type' => 'anomaly.field_type.select',
                'required' => true,
                'config' => [
                    "options" => function (TableTranslatorRepositoryInterface $repository) {
                        return $repository->getTranslateTables();
                    }
                ],
                'rules' => [
                    'validate_records',
                ],
                'validators' => [
                    'validate_records' => [
                        'message' => 'visiosoft.module.translator::message.all_record_translated',
                        'handler' => ValidateRecord::class,
                    ],
                ],
            ],
            'source' => [
                'type' => 'anomaly.field_type.select',
                'required' => true,
                'config' => [
                    "options" => function () {
                        return ['en' =>  trans('streams::locale.en.name')];
                    }
                ],
            ],
            'target' => [
                'type' => 'anomaly.field_type.select',
                'required' => true,
                'config' => [
                    "options" => function () {
                        $locales = setting_value('streams::enabled_locales');
                        return array_combine($locales, $locales);
                    }
                ],
            ],
        ]);
    }
}
