<?php namespace Visiosoft\TranslateModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TranslateModule\Auto\Contract\AutoRepositoryInterface;
use Visiosoft\TranslateModule\Auto\AutoRepository;
use Anomaly\Streams\Platform\Model\Translate\TranslateAutoEntryModel;
use Visiosoft\TranslateModule\Auto\AutoModel;
use Illuminate\Routing\Router;

class TranslateModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/translate'           => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@index',
        'admin/translate/create'    => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@create',
        'admin/translate/edit/{id}' => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@edit',
        'admin/translate/auto' => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@autoTransAllModules',
        'admin/translate/auto2' => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@autoReformatFile',
        'admin/translate/editor/{module_type},{source},{module},{lang},{filename}' => 'Visiosoft\TranslateModule\Http\Controller\Admin\AutoController@editor',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\TranslateModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\TranslateModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\TranslateModule\Event\ExampleEvent::class => [
        //    Visiosoft\TranslateModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\TranslateModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TranslateAutoEntryModel::class => AutoModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        AutoRepositoryInterface::class => AutoRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
