<?php namespace Visiosoft\TranslateModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Module\ModuleModel;
use Illuminate\Http\Request;
use Visiosoft\TranslateModule\Auto\Form\AutoFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class AutoController extends AdminController
{
    private $settings;

    public function __construct(SettingRepositoryInterface $settingRepository)
    {
        parent::__construct();
        $this->settings = $settingRepository;
    }

    public function translateGoogle($text, $convert, $to)
    {
        $apiKey = $this->settings->value('visiosoft.module.translate::translate_api');
        $url = 'https://translation.googleapis.com/language/translate/v2/?key=' . $apiKey . '&q=' . rawurlencode($text) . '&source=' . $convert . '&target=' . $to;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FAILONERROR, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 45);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $responseDecoded = curl_exec($ch);
        curl_close($ch);

        $responseDecoded = json_decode($responseDecoded, true);
        return $responseDecoded['data']['translations'][0]['translatedText'];
    }

    function dirToArray($dir)
    {

        $result = array();

        $cdir = scandir($dir);
        foreach ($cdir as $key => $value) {
            if (!in_array($value, array(".", ".."))) {
                if (is_dir($dir . DIRECTORY_SEPARATOR . $value)) {
                    $result[$value] = dirToArray($dir . DIRECTORY_SEPARATOR . $value);
                } else {
                    $result[] = $value;
                }
            }
        }

        return $result;
    }

    public function runTranslate($convert = "en", $to = "tr", $module = "visiosoft.module.translate")
    {
        $module_array = explode('.', $module);
        $base_path = base_path() . "/addons/default/" . $module_array[0] . "/" . $module_array[2] . "-" . $module_array[1] . "/resources/lang/";
        $field_path = $base_path . $convert;
        $this->makeDirectory($base_path . $to);
        $converted_files = array();
        foreach ($this->dirToArray($field_path) as $file) {
            $new_field_path = $base_path . $to;
            //$this->makeDirectory($new_field_path . "/" . $file);


            $converted_files[$file] = $this->tranlateFile($field_path . "/" . $file, $convert, $to);
            //$file=fopen($new_field_path."/".$file,'w');
            //fwrite($file,json_encode($converted_files[$file]));
            //fclose($file);
            // File::put($new_field_path."/".$converted_files[$file]);
            $dosya = $this->ConvertTransFileFormat($converted_files[$file]);
            file_put_contents($new_field_path . "/" . $file, $dosya);
            $this->reFormatFile($new_field_path . "/" . $file);
        }
    }

    public function rmdir_recursive($dir)
    {
        //Remove Directory Files
        if (is_dir($dir)) {
            foreach (scandir($dir) as $file) {
                if ('.' === $file || '..' === $file) continue;
                if (is_dir("$dir/$file")) rmdir_recursive("$dir/$file");
                else unlink("$dir/$file");
            }
            rmdir($dir);
        }
    }

    public function ConvertTransFileFormat($file)
    {
        $dosya = print_r($file, true);


        $dosya = str_replace("\n", "", $dosya);
        $dosya = str_replace("Array(", "[", $dosya);
        $dosya = str_replace("Array        (", "[", $dosya);
        $dosya = str_replace("Array                (", "[", $dosya);
        $dosya = str_replace(")", " ]", $dosya);
        $dosya = str_replace("[                    [", "\"[\"", $dosya);
        $dosya = str_replace("] => [            [", "\"=>[\"", $dosya);
        $dosya = str_replace("] => ", "\"=>\"", $dosya);
        $dosya = str_replace("                 ]", "\"]", $dosya);
        $dosya = str_replace("=>\"\"", "=>", $dosya);
        $dosya = str_replace("         ]    [", "\",],\"", $dosya);
        $dosya = str_replace("[    [", "[\"", $dosya);
        $dosya = str_replace("    [", "\",\"", $dosya);
        $dosya = str_replace("\"]         ] ]", "\",],],]", $dosya);
        $dosya = str_replace("         ] ]", "\",],]", $dosya);
        $dosya = str_replace("[ ]", "[]", $dosya);
        $dosya = str_replace(" ]", "\"]", $dosya);
        $dosya = str_replace("        \"", "\"", $dosya);
        $dosya = str_replace("]\",]", "],]", $dosya);
        $dosya = "<?php

return " . $dosya . ";";
        return $dosya;
    }

    //Create new Trans Directory
    public function makeDirectory($path, $force = false, $mode = 0777, $recursive = false)
    {
        $this->rmdir_recursive($path);//Remove old Files and Directory
        if ($force) {
            return @mkdir($path, $mode, $recursive);
        } else {
            return mkdir($path, $mode, $recursive);
        }
    }

    public function tranlateFile($field_path, $convert, $to)
    {

        //Read File
        $lang = include($field_path);

        //Translate Lines
        $lang_new = array();
        foreach ($lang as $index => $line) {
            $lang_new[$index] = $line;
            if (is_array($lang_new[$index])) {
                foreach ($lang_new[$index] as $index2 => $item) {
                    if (is_array($lang_new[$index][$index2])) {
                        foreach ($lang_new[$index][$index2] as $index3 => $item2) {
                            $lang_new[$index][$index2][$index3] = $this->translateGoogle($item2, $convert, $to);
                        }
                    } else {
                        $lang_new[$index][$index2] = $this->translateGoogle($item, $convert, $to);
                    }
                }
            } else {
                $lang_new[$index] = $this->translateGoogle($line, $convert, $to);
            }
        }
        return $lang_new;
    }

    function myUrlEncode($string)
    {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }

    public function reFormatFile($filelocation)
    {
        $lang = file_get_contents($filelocation);
        $lang = str_replace('<?php', "", $lang);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://jsonformatter.curiousconcept.com/process",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 600000,
            CURLOPT_TIMEOUT => 600000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "jsondata=" . $this->myUrlEncode($lang) . "&jsonstandard=1&jsontemplate=1",
            //CURLOPT_POSTFIELDS => "jsondata=%0D%0Areturn+%5B%22recently%22%3D%3E%5B%22name%22%3D%3E%22Son+g%C3%BCnlerde%22%2C%22option%22%3D%3E%5B%22read%22%3D%3E%22Son+zamanlarda+okuyabilir+mi%3F++++++++%22%2C%22write%22%3D%3E%22Son+zamanlarda+olu%C5%9Fturabilir+%2F+d%C3%BCzenleyebilir+mi%3F++++++++%22%2C%22delete%22%3D%3E%22Son+zamanlarda+silebilir+miyim%3F%22%2C%5D%2C%5D%2C%5D%3B&jsonstandard=1&jsontemplate=1",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $file = $filelocation;
            file_put_contents($file, "<?php\n\n " . json_decode($response, TRUE)['result']['jsoncopy']);
        }

    }

    public function index(AutoFormBuilder $form, ModuleModel $model, Request $request)
    {
        $modules = $model
            ->where('namespace', 'like', 'visiosoft.module.%')
            ->where('namespace', '!=', 'visiosoft.module.translate')
            ->pluck('namespace', 'namespace')->all();
        $form->setFields([
            'module' => [
                'type' => 'anomaly.field_type.select',
                'label' => 'visiosoft.module.translate::field.module.name',
                'config' => [
                    'options' => $modules,
                ],
            ],
            'convert' => [
                'type' => 'anomaly.field_type.select',
                'label' => 'visiosoft.module.translate::field.convert.name',
                'config' => [
                    'options' => ['en' => 'English'],
                    'default_value' => 'en',
                    'separator' => ':',
                ],
            ],
            'to' => [
                'type' => 'anomaly.field_type.select',
                'label' => 'visiosoft.module.translate::field.to.name',
                'config' => [
                    'options' => [
                        'de' => 'Deutsch',
                        'fa' => 'فارسی',
                        'nl' => 'Nederlands',
                        'el' => 'Ελληνικά',
                        'fr' => 'Français',
                        'es' => 'Español',
                        'ru' => 'Русский',
                        'tr' => 'Türkçe',
                        'pt' => 'Português',
                        'ar' => 'العربية',
                        'it' => 'Italiano'
                    ],
                    'separator' => ':',
                    'default_value' => 'tr',
                ],
            ],
        ]);

        if ($request->action == "save") {
            $request = $request->all();
            $this->runTranslate($request['convert'], $request['to'], $request['module']);
            $form->skipField('convert');
            $form->skipField('to');
            $form->skipField('module');
            return back()->withSuccess([trans('visiosoft.module.translate::message.success'), $request['module']]);
        }
        return $form->render();
    }

    public function autoTransAllModules(ModuleModel $model, $convert = "en", $to = "it")
    {
        $modules = $model
            ->where('namespace', 'like', 'visiosoft.module.%')
            ->where('namespace', '!=', 'visiosoft.module.translate')
            ->pluck('namespace', 'namespace')->all();

        foreach ($modules as $module) {
            $this->runTranslate($convert, $to, $module);
        }
        print_r("success");

    }

    public function autoReformatFile(ModuleModel $model)
    {
        $langs = ['de', 'fa', 'nl', 'el', 'fr', 'es', 'ru', 'tr', 'pt', 'ar', 'it'];
        $modules = $model
            ->where('namespace', 'like', 'visiosoft.module.%')
            ->where('namespace', '!=', 'visiosoft.module.translate')
            ->pluck('namespace', 'namespace')->all();

        foreach ($modules as $module) {
            foreach ($langs as $lang) {
                $module_array = explode('.', $module);
                $base_path = base_path() . "/addons/default/" . $module_array[0] . "/" . $module_array[2] . "-" . $module_array[1] . "/resources/lang/" . $lang . "/";
                foreach ($this->dirToArray($base_path) as $file) {

                    $this->reFormatFile($base_path . $file);
                    //$new_field_path = $base_path . $to;
                }
            }

        }
        print_r("success");
    }

    public function editor(Request $request, AutoFormBuilder $formBuilder, $module_type, $source, $module, $lang, $filename)
    {
        if ($request->action == "save") {
            file_put_contents($request->save_location, $request->editor);
            return back()->withSuccess(['Başarılı']);
        } else {
            if ($module_type != 'core') {
                $module_type = "addons/default";
            }
            $formBuilder->setFields([
                'editor' => [
                    'type' => 'anomaly.field_type.editor',
                    'config' => [
                        'default_value' => file_get_contents('../' . $module_type . '/' . $source . '/' . $module . '-module/resources/lang/' . $lang . '/' . $filename . '.php'),
                    ]
                ],
                'save_location' => [
                    'type' => 'anomaly.field_type.text',
                    'config' => [
                        'default_value' => '../' . $module_type . '/' . $source . '/' . $module . '-module/resources/lang/' . $lang . '/' . $filename . '.php',
                        "type"          => "hidden",
                    ],
                ]
            ]);
            return $formBuilder->render();
        }

    }
}

