<?php

namespace Visiosoft\TopbarLanguagePopupExtension\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;

class ExtensionController extends PublicController
{
    use ApiReturnResponseTrait;

    public function getLanguagePopup(Request $request)
    {
        $inputs = $request->all();
        $ip = $request->ip();

        if(!$ip || $ip == '127.0.0.1'){
            // Set Fake IP
            $ip = '142.250.187.142';

        }
        
        try {
            $location = file_get_contents("https://ipinfo.io/$ip/json");
            $location = json_decode($location, true);
            $location = [
                'country' => trans('streams::country.' . $location['country']),
                'language' => trans('streams::locale.' . strtolower($location['country']) . '.name'),
                'lang' => strtolower($location['country'])
            ];
            $locales = config('streams::locales.enabled');

            if (!in_array($location['lang'], $locales)){
                $location['lang'] = 'en';
                $location['language'] = 'English';
            }
            $notification = trans('visiosoft.extension.topbar_language_popup::field.language_popup', ['country' => $location['country'],
                'language' => $location['language']]);
            $popup = [];
            if ($location['lang'] != config('app.locale') && in_array($location['lang'], $locales)) {
                $popup = $this->view->make('visiosoft.extension.topbar_language_popup::language-popup', [
                    'notification' => $notification,
                    'location' => $location,
                    'callback' => $inputs['callback']
                ])->render();
            }
            return $this->sendResponse($popup, '');
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }

    }
}
