<?php

namespace Visiosoft\TopbarLanguagePopupExtension\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;

class ExtensionController extends PublicController
{
    use ApiReturnResponseTrait;

    public function getLanguagePopup(Request $request)
    {
        $inputs = $request->all();
        $ip = $request->ip();
        try {
            $location = file_get_contents("https://ipinfo.io/$ip/json");
            $location = json_decode($location, true);
            $location = [
                'country' => trans('streams::country.' . $location['country']),
                'language' => trans('streams::locale.' . strtolower($location['country']) . '.name'),
                'lang' => strtolower($location['country'])
            ];
            $notification = trans('visiosoft.extension.topbar_language_popup::field.language_popup', ['country' => $location['country'],
                'language' => $location['language']]);
            $locales = config('streams::locales.enabled');
            $popup = [];
            if ($location['lang'] != config('app.locale') && in_array($location['lang'], $locales)) {
                $popup = $this->view->make('visiosoft.extension.topbar_language_popup::language-popup', [
                    'notification' => $notification,
                    'location' => $location,
                    'callback' => $inputs['callback']
                ])->render();
            }
            return $this->sendResponse($popup, '');
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }

    }
}