class MapUi {
    constructor() {
        this.onInput = this.onInput.bind(this);

        this.changeMapTypeButton = document.querySelector('.map-type-button');
        this.allStationsButton = document.querySelector('.all-stations-button');
        this.allStationsModal = document.querySelector('.all-stations-modal');
        this.allStationsCloseButton = document.querySelector('.all-stations-modal-close');
        this.lejantButton = document.querySelector('.lejant-button');
        this.lejantModal = document.querySelector('.lejant-modal');
        this.lejantCloseButton = document.querySelector('.lejant-modal-close');
        this.typesModal = document.querySelector('.types');
        this.typeIcon = document.querySelector('#type-icon');
        this.text = document.querySelector('.map-type-button-text');
        this.filterButton = document.querySelector('.filter-button');
        this.filterModalCloseButton = document.querySelector('.filter-modal-close');
        this.filterModal = document.querySelector('.filter-modal');
        this.socketTypeButtons = document.querySelectorAll('.radio_type');


        this.lejantButton.addEventListener('click', () => {
            this.lejantModal.classList.remove('hidden');
        });

        this.lejantCloseButton.addEventListener('click', () => {
            this.lejantModal.classList.add('hidden');
        });

        this.allStationsCloseButton.addEventListener('click', () => {
            this.allStationsModal.classList.add('hidden');
            this.allStationsButton.classList.remove('lg-d-none')
            document.querySelector('.modal-container#allstation').style.zIndex = -1;
        })

        const mediaQuery = window.matchMedia('(min-width: 768px)');
        if (mediaQuery.matches) {
            this.changeMapTypeButton.addEventListener('mouseover', () => {
                if (this.typesModal.classList.contains('hidden')) {
                    this.changeMapTypeButton.style.width = '155px';
                    this.text.classList.add('text-hover');
                }
            });

            this.changeMapTypeButton.addEventListener('mouseout', () => {
                this.changeMapTypeButton.style.width = '40px';
                this.text.classList.remove('text-hover')
            });
        }

        this.changeMapTypeButton.addEventListener('click', () => {
            if (!this.typesModal.classList.contains('hidden')) {
                this.typesModal.classList.add('hidden');
                this.typeIcon.src = `${mapTypeIcon}`;
                this.changeMapTypeButton.classList.remove('active');
                if (mediaQuery.matches) {
                    this.changeMapTypeButton.style.width = '155px';
                    this.text.classList.add('text-hover');
                }
            } else {
                this.typesModal.classList.remove('hidden');
                this.changeMapTypeButton.classList.add('active')
                if (mediaQuery.matches) {
                    this.text.classList.remove('text-hover');
                }
                this.typeIcon.src = `${mapTypeActiveIcon}`;
            }
        })

        this.filterButton.addEventListener('click', () => {
            hiddenAllModals();
            this.filterModal.classList.remove('hidden');
            document.querySelector('.modal-container#filtermodal').style.zIndex = 99999999;
        })

        this.filterModalCloseButton.addEventListener('click', () => {
            this.filterModal.classList.add('hidden');
            document.querySelector('.modal-container#filtermodal').style.zIndex = -1;
        })

        document.querySelectorAll(".range-slider").forEach((range) =>
            range.querySelectorAll("input").forEach((input) => {
                if (input.type === "range") {
                    input.oninput = (e) => this.onInput(range, e);
                    this.onInput(range);
                }
            })
        );

        this.socketTypeButtons.forEach(button => button.addEventListener('click', () => {
            document.querySelectorAll('.filter_socket_type').forEach(label => label.classList.remove('active'));
            document.querySelector('label[for="' + button.id + '"]').classList.add('active');
        }))
    }

    onInput(parent, e) {
        const slides = parent.querySelectorAll("input");
        const min = parseFloat(slides[0].min);
        const max = parseFloat(slides[0].max);

        let slide1 = parseFloat(slides[0].value);
        let slide2 = parseFloat(slides[1].value);

        const percentageMin = (slide1 / (max - min)) * 100;
        const percentageMax = (slide2 / (max - min)) * 100;

        parent.style.setProperty("--range-slider-value-low", percentageMin);
        parent.style.setProperty("--range-slider-value-high", percentageMax);

        if (slide1 > slide2) {
            const tmp = slide2;
            slide2 = slide1;
            slide1 = tmp;

            if (e?.currentTarget === slides[0]) {
                slides[0].insertAdjacentElement("beforebegin", slides[1]);
            } else {
                slides[1].insertAdjacentElement("afterend", slides[0]);
            }
        }
        document.querySelectorAll('.active-step').forEach(x => x.classList.add('d-none'));
        if (slide1 != 0 && slide1 != 250) {
            document.querySelector('#kw' + slide1).classList.remove('d-none');
        }
        if (slide2 != 250 && slide2 != 0) {
            document.querySelector('#kw' + slide2).classList.remove('d-none');
        }
        document.querySelectorAll('.charge-speed-box #steps span').forEach(box => box.classList.remove('rounded-box'));
        for (let i = 0; i < 250; i += 50) {
            if (i > slide1 && i < slide2) {
                document.querySelector('#kw' + i).parentElement.classList.add('rounded-box');
            }
        }
        parent
            .querySelector(".range-slider__display")
            .setAttribute("data-low", slide1);
        parent
            .querySelector(".range-slider__display")
            .setAttribute("data-high", slide2);
    };
}

function hiddenAllModals() {
    let modals = document.querySelectorAll('.modal-container');
    modals.forEach(modal => {
        modal.style.zIndex = -1;
    })
}

class Map {
    static loader() {
        return `<div id="#loader" class="loaderWrapper">
                    <div class="spinner-border" style="width: 3rem; height: 3rem;" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>`
    }

    static removeLoader() {
        document.querySelector('.loaderWrapper').remove();
    }

    constructor(elementId) {
        this.map = null;
        this.elementId = elementId;
        this.url = `${endpoint}`;
        this.turkeyBounds = {
            north: 44,
            south: 34,
            west: 23,
            east: 46
        };
        this.markerCluster;
        this.allMarkers = [];
        this.defaultIconSize;
        this.enlargedIconSize;
        this.filteredMarkers = this.allMarkers;
        this.options = {
            method: 'GET',
            headers: {}
        };
        this.mapUi = new MapUi();

        this.darkMap = [
            {elementType: "geometry", stylers: [{color: "#242f3e"}]},
            {elementType: "labels.text.stroke", stylers: [{color: "#242f3e"}]},
            {elementType: "labels.text.fill", stylers: [{color: "#746855"}]},
            {
                featureType: "administrative.locality",
                elementType: "labels.text.fill",
                stylers: [{color: "#d59563"}],
            },
            {
                featureType: "poi",
                elementType: "labels.text.fill",
                stylers: [{color: "#d59563"}],
            },
            {
                featureType: "poi.park",
                elementType: "geometry",
                stylers: [{color: "#263c3f"}],
            },
            {
                featureType: "poi.park",
                elementType: "labels.text.fill",
                stylers: [{color: "#6b9a76"}],
            },
            {
                featureType: "road",
                elementType: "geometry",
                stylers: [{color: "#38414e"}],
            },
            {
                featureType: "road",
                elementType: "geometry.stroke",
                stylers: [{color: "#212a37"}],
            },
            {
                featureType: "road",
                elementType: "labels.text.fill",
                stylers: [{color: "#9ca5b3"}],
            },
            {
                featureType: "road.highway",
                elementType: "geometry",
                stylers: [{color: "#746855"}],
            },
            {
                featureType: "road.highway",
                elementType: "geometry.stroke",
                stylers: [{color: "#1f2835"}],
            },
            {
                featureType: "road.highway",
                elementType: "labels.text.fill",
                stylers: [{color: "#f3d19c"}],
            },
            {
                featureType: "transit",
                elementType: "geometry",
                stylers: [{color: "#2f3948"}],
            },
            {
                featureType: "transit.station",
                elementType: "labels.text.fill",
                stylers: [{color: "#d59563"}],
            },
            {
                featureType: "water",
                elementType: "geometry",
                stylers: [{color: "#17263c"}],
            },
            {
                featureType: "water",
                elementType: "labels.text.fill",
                stylers: [{color: "#515c6d"}],
            },
            {
                featureType: "water",
                elementType: "labels.text.stroke",
                stylers: [{color: "#17263c"}],
            },
        ]

        this.zoomInButton = document.querySelector('.zoom-buttons-in');
        this.zoomOutButton = document.querySelector('.zoom-buttons-out');
        this.stationDetailModal = document.querySelector('.station-detail-modal');
        this.stationDetailModalCloseButton = document.querySelector('.station-detail-modal-close');
        this.modals = document.querySelectorAll('.modal-container');
        this.resultsContainer = document.getElementById('resultsContainer');
        this.searchResultModalContainer = document.querySelector('.modal-container#searchResultModal');
        this.mapTypes = document.querySelectorAll('.type-box');
    }

    init() {
        this.defaultIconSize = new google.maps.Size(50, 50);
        this.enlargedIconSize = new google.maps.Size(65, 65);
        var options = {
            zoom: 6,
            center: {
                lat: 21.095533,
                lng: 28.803121
            },
            disableDefaultUI: true,
            clickableIcons: false,
            zoomControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            restriction: {
                latLngBounds: this.turkeyBounds,
            },
        }

        this.map = new google.maps.Map(document.getElementById(this.elementId), options);

        this.fetchDataAndAddMarkers();

        this.stationDetailModalCloseButton.addEventListener('click', () => {
            this.stationDetailModal.classList.add('hidden');
            document.querySelector('.modal-container#stationdetail').style.zIndex = -1;
            document.querySelector('.modal-container#searchResultModal').style.zIndex = 999999;

            this.allMarkers.forEach(marker => marker.setIcon({
                url: marker.getIcon().url,
                scaledSize: this.defaultIconSize
            }))
        });

        google.maps.event.addDomListener(this.zoomInButton, 'click', () => {
            this.map.setZoom(this.map.getZoom() + 1);
        });

        google.maps.event.addDomListener(this.zoomOutButton, 'click', () => {
            this.map.setZoom(this.map.getZoom() - 1);
        });

        this.mapTypes.forEach(type => type.addEventListener('click', () => {
            if (type.id == 'dark') {
                this.map.setOptions({
                    styles: this.darkMap
                })
            } else if (type.id == 'light') {
                this.map.setOptions({
                    styles: []
                })
            } else {
                this.map.setMapTypeId(type.id);
            }
        }));

        document.querySelector('#filterForm').addEventListener('submit', (e) => {
            e.preventDefault();
            this.mapUi.filterButton.classList.add('active');

            let actionUrl = new URL(`${this.url}/map/charge-map`);
            let power_min = document.querySelector('#power_min').value;
            let power_max = document.querySelector('#power_max').value;
            let current_type = document.querySelector('input[name=socket_type]:checked').value;
            var params = {power_min, power_max, current_type};

            actionUrl.search = new URLSearchParams(params);

            document.querySelector('.wrapper').insertAdjacentHTML('beforeend', Map.loader());
            fetch(actionUrl)
                .then(response => response.json())
                .then(data => {
                    this.filteredMarkers = this.allMarkers.filter(marker => data.some(item => item.id === marker.id));
                    this.setMapOnAll(this.filteredMarkers);
                    this.markerCluster.clearMarkers();
                    this.markerCluster.addMarkers(this.filteredMarkers);
                }).catch(err => console.warn('error', err)).finally(() =>
                Map.removeLoader()
            );
        });

        document.querySelector('.button.clear').addEventListener('click', () => {
            this.mapUi.filterButton.classList.remove('active');
            this.setMapOnAll(this.allMarkers);
            this.markerCluster.clearMarkers();
            this.markerCluster.addMarkers(this.allMarkers);
        });


        this.mapUi.allStationsButton.addEventListener('click', async () => {
            hiddenAllModals();
            try {
                this.mapUi.allStationsModal.classList.remove('hidden');
                this.mapUi.allStationsButton.classList.add('lg-d-none')
                this.mapUi.allStationsModal.insertAdjacentHTML('beforeend', Map.loader());
                document.querySelector('.modal-container#allstation').style.zIndex = 99999999;

                const response = await fetch(`${this.url}/map/charge-map`, this.options);
                const data = await response.json();

                const stationsContainer = document.querySelector('#all_stations_modal_content .stations');
                stationsContainer.innerHTML = '';

                data.forEach(station => {
                    stationsContainer.appendChild(mapViews.createStationElement(station, true))
                })
            } catch (err) {
                console.warn('error', err);
            } finally {
                Map.removeLoader();
            }
        });


        this.initSearchInput();
    }

    clearResults() {
        this.resultsContainer.style.display = "none";
        this.resultsContainer.innerHTML = '';
    }

    initSearchInput() {
        const searchInput = document.getElementById('searchInput');
        let timeoutId;
        const makeRequest = () => {
            const inputValue = searchInput.value;
            clearTimeout(timeoutId);

            if (inputValue.length > 3) {
                hiddenAllModals();
                timeoutId = setTimeout(() => {
                    const actionUrl = `${this.url}/map/charge-map?keyword=${encodeURIComponent(inputValue)}`;
                    fetch(actionUrl)
                        .then(response => response.json())
                        .then(displayResults);
                }, 300);
            } else {
                this.clearResults();
            }
        }

        const displayResults = (data) => {
            this.clearResults();
            if (data.length > 0) {
                this.resultsContainer.style.display = 'block';
                data.forEach(result => {
                    const stationElement = mapViews.createStationElement(result);
                    this.resultsContainer.appendChild(stationElement);
                    this.searchResultModalContainer.style.zIndex = 999999;
                });
            } else {
                this.resultsContainer.style.display = 'none';
            }
        }
        searchInput.addEventListener('input', makeRequest);
    }

    setMapOnAll(markers) {
        this.allMarkers.forEach(x => x.setMap(null));
        for (let i = 0; i < markers.length; i++) {
            markers[i].setMap(this.map);
        }
    }



    AddMarker(options) {
        var map = this.map;
        const marker = new google.maps.Marker({
            position: options.coordinates,
            map,
            icon: options.image ? options.image : image,
            id: options.id
        });

        const infoWindow = new google.maps.InfoWindow({
            content: `<div style="min-height:200px; min-width:300px">${Map.loader()}</div>`,
        });

        let infoWindowLoading = false;
        this.allMarkers.push(marker);

        marker.addListener('mouseover', () => {
            infoWindow.open(this.map, marker);
            marker.setIcon({url: marker.getIcon().url, scaledSize: this.enlargedIconSize});

            if (!infoWindow.isOpen && !infoWindowLoading) {
                infoWindowLoading = true;
                this.fetchStationDetail(marker.id)
                    .then(data => {
                        infoWindow.setContent(mapViews.infoWindowCreater(data.station));
                    })
                    .catch(err => console.warn('error', err))
                    .finally(() => {
                        infoWindowLoading = false;
                    });
            }
        });

        marker.addListener('mouseout', () => {
            setTimeout(() => {
                if (!infoWindow.isOpen) {
                    infoWindow.close();
                    infoWindow.isOpen = false;

                    marker.setIcon({
                        url: marker.getIcon().url,
                        scaledSize: this.defaultIconSize,
                    });
                }
            }, 100);
        });

        marker.addListener('click', () => {
            hiddenAllModals();
            this.stationDetailModal.insertAdjacentHTML('beforeend', Map.loader());
            this.stationDetailModal.classList.remove('hidden');
            document.querySelector('.modal-container#stationdetail').style.zIndex = 9999999;

            this.fetchStationDetail(marker.id)
                .then(data => {
                    document.querySelector('.station-detail-name').innerHTML = data.station.title;
                    document.querySelector('#detail_address').innerHTML = data.station.address_line_1 + ' ' + (data.station.address_line_2 ? data.station.address_line_2 : '');
                    document.querySelector('#detail_phone').innerHTML = data.station.contact_telephone_1 ? data.station.contact_telephone_1 : '-------';
                    const socketTypeContainer = document.querySelector('.station-detail-sockets .sockets .socket-type');
                    socketTypeContainer.innerHTML = '';
                    socketTypeContainer.insertAdjacentHTML('beforeend', mapViews.stationModalConnections(data.station.connections, true));
                })
                .catch(err => console.warn('error', err))
                .finally(() => {
                    marker.setIcon({
                        url: marker.getIcon().url,
                        scaledSize: this.enlargedIconSize,
                    });
                    document.querySelectorAll('.loaderWrapper').forEach(loader => loader.remove())
                });
        });
    }

    async fetchDataAndAddMarkers() {
        try {
            const response = await fetch(`${this.url}/map/charge-map`);
            const data = await response.json();
            const markerChargeElement = document.querySelector('#marker_charge');
            const markerCountElement = markerChargeElement.querySelector('.marker-count');
            markerCountElement.innerHTML = data.length;
            for (const station of data) {
                const myLatLng = {lat: parseFloat(station.lat), lng: parseFloat(station.lon)};
                this.AddMarker({
                    coordinates: myLatLng,
                    image: {url: `${markerIcon}`, scaledSize: this.defaultIconSize},
                    id: station.id
                });

            }
        } catch (error) {
            console.warn('error', error);
        } finally {
            this.createCluster();
            Map.removeLoader();

        }
    }

    async fetchStationDetail(stationId) {
        try {
            const response = await fetch(`${this.url}/map/charge-map/detail/station/${stationId}`);
            const data = await response.json();
            return data;
        } catch (error) {
            console.warn('Error fetching station detail:', error);
            throw error;
        }
    }

    // CLUSTER
    createCluster(currentMarkers = this.allMarkers) {
        var mcOptions = {
            gridSize: 40,
            zoomOnClick: false,
            minimumClusterSize: 3,
            imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'
        };

        let maxZoom = 15;
        this.markerCluster = new MarkerClusterer(this.map, currentMarkers, mcOptions);
        google.maps.event.addListener(this.markerCluster, 'clusterclick', (cluster) => { // Use arrow function here
            var targetZoom = this.map.getZoom() + 3 < maxZoom ? this.map.getZoom() + 3 : maxZoom;
            var zoomInterval = setInterval(() => { // Use arrow function here
                var latLng = new google.maps.LatLng(cluster.getCenter());

                if (this.map.getZoom() >= targetZoom) {
                    clearInterval(zoomInterval);
                } else {
                    this.slowPanTo(latLng);
                    if (this.map.getZoom() < maxZoom) {
                        this.map.setZoom(this.map.getZoom() + 1);
                    }
                }
            }, 200);
        });
    }

    slowPanTo(targetLatLng) {
        var numFrames = 20;
        var delay = 8;
        var i = 0;
        var startLat = this.map.getCenter().lat();
        var startLng = this.map.getCenter().lng();
        var deltaLat = (targetLatLng.lat() - startLat) / numFrames;
        var deltaLng = (targetLatLng.lng() - startLng) / numFrames;

        const step = () => {
            i++;
            if (i < numFrames) {
                var newLat = startLat + i * deltaLat;
                var newLng = startLng + i * deltaLng;
                this.map.panTo(new google.maps.LatLng(newLat, newLng));
                setTimeout(step, delay);
            }
        }
        step();
    }

    handleClick(result) {
        this.searchResultModalContainer.style.zIndex = -1;
        const targetMarker = this.allMarkers.find(marker => marker.id === result.id);
        this.map.setZoom(15);
        this.map.setCenter(targetMarker.getPosition());

        document.querySelector('.station-detail-name').innerHTML = result.title;
        document.querySelector('#detail_address').innerHTML = result.address_line_1 + ' ' + (result.address_line_2 ? result.address_line_2 : '');
        document.querySelector('#detail_phone').innerHTML = result.contact_telephone_1 ? result.contact_telephone_1 : '-------';
        document.querySelector('.station-detail-sockets .sockets .socket-type').innerHTML = '';
        document.querySelector('.station-detail-sockets .sockets .socket-type').insertAdjacentHTML('beforeend', mapViews.stationModalConnections(result.connections, true));

        hiddenAllModals();

        this.stationDetailModal.classList.remove('hidden');
        document.querySelector('.modal-container#stationdetail').style.zIndex = 9999999;
        targetMarker.setIcon({url: targetMarker.getIcon().url, scaledSize: this.enlargedIconSize});
    }

}

const mapApp = new Map('map');
mapApp.init();

class MapViews {
    constructor(map) {
        this.stateStyles = {
            1: ['color:#18C941', `${available}`],
            2: ['color:#124AE9', `${connected}`],
            3: ['color:#EC8E00', `${on_charge}`],
            4: ['color:#C91818', `${unavailable}`],
            5: ['color:#60626D', `${incorrect}`],
        };
        this.map = map;
    }


    infoWindowCreater(data) {
        const types = data.connection_types.map((type) => `
        <div class="charge-type">
            <img class="charge-type-icon" src="${type.detail.icon_url}" alt="${type.detail.formal_name}">
            <div class="charge-type-content">
                <span>${type.detail.title}</span>
                <span class="count">${type.available_count}/${type.count}</span>
            </div>
        </div>`
        ).join('');

        return `
        <div class="station-hover">
            <h2 class="hover-title">${data.title}</h2>
            <img class="cover-photo" src="${defaultToger}" alt="toger">
            <div class="socket-types-wrapper">
                <h4>Soket tipleri</h4>
                <div class="socket-types">
                    ${types}
                </div>
            </div>
        </div>`;
    }

    connectionState(state) {
        if (state in this.stateStyles) {
            return `<div style="${this.stateStyles[state][0]}">${this.stateStyles[state][1]}</div>`;
        }
        return '';
    }

    stationModalConnections(connections, detail = false) {
        return connections.map((connection) => `
        <div class="charge-type ${detail ? 'detail' : ''}">
            <img src="${acIcon}" alt="${connection.connection_type.formal_name}">
            <div class="charge-type-content">
                <span class="name">${connection.connection_type.formal_name}</span>
                <span class="count">${this.connectionState(connection.last_status?.state_id)}</span>
            </div>
        </div>`
        ).join('');
    }

    createStationElement(result, connections = false) {
        const station =
            `<div class="d-flex align-items-center">
                <img class="stationIcon" src="${markerIcon}" alt="marker">
                <div class="location">
                    <div class="location-title">${result.title}</div>
                    <div class="location-address">${result.address_line_1} ${result.address_line_2 ? result.address_line_2 : ''}</div>
                </div>
            </div>`;
        const stationElement = document.createElement('div');
        stationElement.classList.add('station');
        stationElement.innerHTML = station;

        if (connections) {
            stationElement.insertAdjacentHTML('beforeend', this.stationModalConnections(result.connections, false));
        }
        stationElement.addEventListener('click', () => this.map.handleClick(result));
        return stationElement;
    }
}


const mapViews = new MapViews(mapApp);
