<?php

namespace Visiosoft\TogerTheme\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ParkingModule\Park\Contract\ParkRepositoryInterface;

class AuthCheck
{

    public function handle(Request $request, Closure $next)
    {
        if ($request->path() == "/") {
            if (!Auth::check()) {
                return redirect('/login');
            }

            return redirect('/control-panel/all_points');
        }

        return $next($request);
    }
}