let darkMap = [
    {elementType: "geometry", stylers: [{color: "#242f3e"}]},
    {elementType: "labels.text.stroke", stylers: [{color: "#242f3e"}]},
    {elementType: "labels.text.fill", stylers: [{color: "#746855"}]},
    {
        featureType: "administrative.locality",
        elementType: "labels.text.fill",
        stylers: [{color: "#d59563"}],
    },
    {
        featureType: "poi",
        elementType: "labels.text.fill",
        stylers: [{color: "#d59563"}],
    },
    {
        featureType: "poi.park",
        elementType: "geometry",
        stylers: [{color: "#263c3f"}],
    },
    {
        featureType: "poi.park",
        elementType: "labels.text.fill",
        stylers: [{color: "#6b9a76"}],
    },
    {
        featureType: "road",
        elementType: "geometry",
        stylers: [{color: "#38414e"}],
    },
    {
        featureType: "road",
        elementType: "geometry.stroke",
        stylers: [{color: "#212a37"}],
    },
    {
        featureType: "road",
        elementType: "labels.text.fill",
        stylers: [{color: "#9ca5b3"}],
    },
    {
        featureType: "road.highway",
        elementType: "geometry",
        stylers: [{color: "#746855"}],
    },
    {
        featureType: "road.highway",
        elementType: "geometry.stroke",
        stylers: [{color: "#1f2835"}],
    },
    {
        featureType: "road.highway",
        elementType: "labels.text.fill",
        stylers: [{color: "#f3d19c"}],
    },
    {
        featureType: "transit",
        elementType: "geometry",
        stylers: [{color: "#2f3948"}],
    },
    {
        featureType: "transit.station",
        elementType: "labels.text.fill",
        stylers: [{color: "#d59563"}],
    },
    {
        featureType: "water",
        elementType: "geometry",
        stylers: [{color: "#17263c"}],
    },
    {
        featureType: "water",
        elementType: "labels.text.fill",
        stylers: [{color: "#515c6d"}],
    },
    {
        featureType: "water",
        elementType: "labels.text.stroke",
        stylers: [{color: "#17263c"}],
    },
]

let allMarkers = [];

let url = 'https://apptest.toger.co';

const stateStyles = {
    1: ['color:#18C941', `${available}`],
    2: ['color:#124AE9', `${connected}`],
    3: ['color:#EC8E00', `${on_charge}`],
    4: ['color:#C91818', `${busy}`],
    5: ['color:#60626D', `${incorrect}`],
};

let options = {
    method: 'GET',
    headers: {}
};

var turkeyBounds = {
    north: 42.107537,
    south: 35.808678,
    west: 25.663789,
    east: 44.822151
};
function loader() {
    return `<div class="lds-roller"><section><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></section></div>`
}
function connectionState(state) {
    if (state in stateStyles) {
        return `<div style="${stateStyles[state][0]}">${stateStyles[state][1]}</div>`;
    }
    return '';
}

function infoWindowCreater(data) {
    const types = data.connection_types.map((type) => `
        <div class="charge-type">
            <img class="charge-type-icon" src="${type.detail.icon_url}" alt="${type.detail.formal_name}">
            <div class="charge-type-content">
                <span>${type.detail.title}</span>
                <span class="count">${type.available_count}/${type.count}</span>
            </div>
        </div>`
    ).join('');

    return `
        <div class="station-hover">
            <h2 class="hover-title">${data.title}</h2>
            <img class="cover-photo" src="${defaultToger}" alt="toger">
            <div class="socket-types-wrapper">
                <h4>Soket tipleri</h4>
                <div class="socket-types">
                    ${types}
                </div>
            </div>
        </div>`;
}

function stationModalConnections(connections, detail = false) {
    return connections.map((connection) => `
        <div class="charge-type ${detail ? 'detail' : ''}">
            <img src="${acIcon}" alt="${connection.connection_type.formal_name}">
            <div class="charge-type-content">
                <span class="name">${connection.connection_type.formal_name}</span>
                <span class="count">${connectionState(connection.last_status?.state_id)}</span>
            </div>
        </div>`
    ).join('');
}

function stationModalInfo(data) {
    return data.map(station => `
        <div class="station">
            <div class="d-flex align-items-center">
                <img class="stationIcon" src="${markerIcon}" alt="marker">
                <div class="location">
                    <div class="location-title">${station.title}</div>
                    <div class="location-address">${station.address_line_1}</div>
                </div>
            </div>
            ${stationModalConnections(station.connections, false)}
        </div>`
    ).join('');
}

var zoomInButton = document.querySelector('.zoom-buttons-in');
var zoomOutButton = document.querySelector('.zoom-buttons-out');
var changeMapTypeButton = document.querySelector('.map-type-button');
var typesModal = document.querySelector('.types');

let allStationsButton = document.querySelector('.all-stations-button');
let allStationsModal = document.querySelector('.all-stations-modal');
let allStationsCloseButton = document.querySelector('.all-stations-modal-close');

let lejantButton = document.querySelector('.lejant-button');
let lejantModal = document.querySelector('.lejant-modal');
let lejantCloseButton = document.querySelector('.lejant-modal-close');

let stationDetailModal = document.querySelector('.station-detail-modal');
let stationDetailModalCloseButton = document.querySelector('.station-detail-modal-close');

let modals = document.querySelectorAll('.modal-container');

let map;
var markerCluster;
var enlargedIconSize;
var defaultIconSize;

const searchInput = document.getElementById('searchInput');
const resultsContainer = document.getElementById('resultsContainer');
let timeoutId;

function hiddenAllModals(){
    modals.forEach(modal => {
        modal.style.zIndex= -1;
    })
}

allStationsButton.addEventListener('click', async () => {
    hiddenAllModals();

    try {
        allStationsModal.classList.remove('hidden');
        allStationsButton.classList.add('lg-d-none')
        allStationsModal.insertAdjacentHTML('beforeend', loader());
        document.querySelector('.modal-container#allstation').style.zIndex = 99999999;

        const response = await fetch(`${url}/map/charge-map`, options);
        const data = await response.json();

        const stationsContainer = document.querySelector('#all_stations_modal_content .stations');
        stationsContainer.innerHTML = '';
        stationsContainer.insertAdjacentHTML('beforeend', stationModalInfo(data));
    } catch (err) {
        console.warn('error', err);
    } finally {
        document.querySelector('.lds-roller').remove();
    }
});

lejantButton.addEventListener('click', function () {
    lejantModal.classList.remove('hidden');
});

lejantCloseButton.addEventListener('click', function () {
    lejantModal.classList.add('hidden');
});

function createCluster(currentMarkers = allMarkers) {
    var mcOptions = {
        gridSize: 40,
        maxZoom: 14,
        zoomOnClick: false,
        minimumClusterSize: 2,
        maximumClusterSize: 3,
        imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'
    };
    markerCluster = new MarkerClusterer(map, currentMarkers, mcOptions);
    google.maps.event.addListener(markerCluster, 'clusterclick', function (cluster) {
        var targetZoom = map.getZoom() + 4;
        var zoomInterval = setInterval(function () {
            var latLng = new google.maps.LatLng(cluster.getCenter());

            if (map.getZoom() >= targetZoom) {
                clearInterval(zoomInterval);
                // Yavaşça pan yapacak fonksiyonu burada çağırıyoruz
            } else {
                slowPanTo(latLng);
                map.setZoom(map.getZoom() + 1);
            }
        }, 200);
    });
}

function slowPanTo(targetLatLng) {
    var numFrames = 20;
    var delay = 8;
    var i = 0;
    var deltaLat = (targetLatLng.lat() - map.getCenter().lat()) / numFrames;
    var deltaLng = (targetLatLng.lng() - map.getCenter().lng()) / numFrames;

    function step() {
        i++;
        if (i < numFrames) {
            var newLat = map.getCenter().lat() + deltaLat;
            var newLng = map.getCenter().lng() + deltaLng;
            map.panTo(new google.maps.LatLng(newLat, newLng));
            setTimeout(step, delay);
        }
    }

    step();
}


document.addEventListener("DOMContentLoaded", function () {
    fetch(`${url}/map/charge-map`, options)
        .then(response => response.json())
        .then(data => {
            document.querySelector('#marker_charge .marker-count').innerHTML = data.length

            data.forEach(function (station, index) {
                const myLatLng = {lat: parseFloat(station.lat), lng: parseFloat(station.lon)};
                AddMarker({
                    coordinates: myLatLng,
                    image: {url: `${markerIcon}`, scaledSize: defaultIconSize},
                    id: station.id
                })
            });
        }).catch(err => console.warn('error', err)).finally(() => {
        createCluster();
        document.querySelector('.lds-roller').remove();
    });

    function AddMarker(options) {
        const marker = new google.maps.Marker({
            position: options.coordinates,
            map,
            icon: options.image ? options.image : image,
            id: options.id
        });

        const infoWindow = new google.maps.InfoWindow({
            content: `<div style="min-height:200px; min-width:300px">${loader()}</div>`,
        });


        let infoWindowLoading = false;
        allMarkers.push(marker);

        marker.addListener('mouseover', () => {
            stationDetailModal.insertAdjacentHTML('beforeend', loader());
            infoWindow.open(map, marker);

            marker.setIcon({ url: marker.getIcon().url, scaledSize: enlargedIconSize });

            if (!infoWindow.isOpen && !infoWindowLoading) {
                infoWindowLoading = true;
                fetch(`${url}/map/charge-map/detail/station/${marker.id}`, options)
                    .then(response => response.json())
                    .then(data => {
                        infoWindow.setContent(infoWindowCreater(data.station));
                        document.querySelector('.station-detail-name').innerHTML = data.station.title;
                        document.querySelector('#detail_address').innerHTML = data.station.address_line_1 + ' ' + (data.station.address_line_2 ? data.station.address_line_2 : '');
                        document.querySelector('#detail_phone').innerHTML = data.station.contact_telephone_1 ? data.station.contact_telephone_1 : '-------';
                        const socketTypeContainer = document.querySelector('.station-detail-sockets .sockets .socket-type');
                        socketTypeContainer.innerHTML = '';
                        socketTypeContainer.insertAdjacentHTML('beforeend', stationModalConnections(data.station.connections, true));

                    }).catch(err => console.warn('error', err))
                    .finally(() => {
                        infoWindowLoading = false;
                        document.querySelectorAll('.lds-roller').forEach(loader => loader.remove());
                    });

            }
        });

        marker.addListener('mouseout', () => {
            setTimeout(() => {
                if (!infoWindow.isOpen) {
                    infoWindow.close();
                    infoWindow.isOpen = false;

                    marker.setIcon({
                        url: marker.getIcon().url,
                        scaledSize: defaultIconSize,
                    });
                }
            }, 100);
        });

        marker.addListener('click', () => {
            hiddenAllModals();

            stationDetailModal.classList.remove('hidden');
            infoWindow.close();
            document.querySelector('.modal-container#stationdetail').style.zIndex = 9999999;
            marker.setIcon({
                url: marker.getIcon().url,
                scaledSize: enlargedIconSize,
            });
        });
    }

    var filteredMarkers = allMarkers;
    var maxLat = Math.atan(Math.sinh(Math.PI)) * 180 / Math.PI;

    function initMap() {
        defaultIconSize = new google.maps.Size(50, 50);
        enlargedIconSize = new google.maps.Size(65, 65);

        var options = {
            zoom: 1,
            center: {
                lat: 21.095533,
                lng: 28.803121
            },
            disableDefaultUI: true,
            clickableIcons: false,
            zoomControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            restriction: {
                latLngBounds: turkeyBounds,
                // strictBounds: true
            },
        }
        map = new google.maps.Map(document.getElementById("map"), options);
        console.log(map);

        document.querySelector('.wrapper').insertAdjacentHTML('beforeend', loader());

        google.maps.event.addDomListener(zoomInButton, 'click', function () {
            map.setZoom(map.getZoom() + 1);
        });

        google.maps.event.addDomListener(zoomOutButton, 'click', function () {
            map.setZoom(map.getZoom() - 1);
        });

    }

    window.initMap = initMap;

    let mapTypes = document.querySelectorAll('.type-box');

    mapTypes.forEach(type => type.addEventListener('click', () => {
        if (type.id == 'dark') {
            map.setOptions({
                styles: darkMap
            })
        } else if (type.id == 'light') {
            map.setOptions({
                styles: []
            })
        } else {
            map.setMapTypeId(type.id);
        }
    }));

    let text = document.querySelector('.map-type-button-text');
    let typeIcon = document.querySelector('#type-icon');


    const mediaQuery = window.matchMedia('(min-width: 768px)');
    if (mediaQuery.matches) {
        changeMapTypeButton.addEventListener('mouseover', () => {
            if (typesModal.classList.contains('hidden')) {
                changeMapTypeButton.style.width = '155px';
                text.classList.add('text-hover');
            }
        });

        changeMapTypeButton.addEventListener('mouseout', () => {
            changeMapTypeButton.style.width = '40px';
            text.classList.remove('text-hover')
        });

    }

    changeMapTypeButton.addEventListener('click', () => {
        if (!typesModal.classList.contains('hidden')) {
            typesModal.classList.add('hidden');
            typeIcon.src = `${mapTypeIcon}`;
            changeMapTypeButton.classList.remove('active');
            if (mediaQuery.matches) {
                changeMapTypeButton.style.width = '155px';
                text.classList.add('text-hover');
            }
        } else {
            typesModal.classList.remove('hidden');
            changeMapTypeButton.classList.add('active')
            if (mediaQuery.matches) {
                text.classList.remove('text-hover');
            }
            typeIcon.src = `${mapTypeActiveIcon}`;
        }
    })

    function setMapOnAll(markers) {
        allMarkers.forEach(x => x.setMap(null));
        for (let i = 0; i < markers.length; i++) {
            markers[i].setMap(map);
        }
    }

    document.querySelector('#filterForm').addEventListener('submit', function (e) {
        e.preventDefault();

        let actionUrl = new URL(`${url}/map/charge-map`);
        let power_min = document.querySelector('#power_min').value;
        let power_max = document.querySelector('#power_max').value;
        let current_type = document.querySelector('input[name=socket_type]:checked').value;
        var params = {power_min, power_max, current_type};

        actionUrl.search = new URLSearchParams(params);

        document.querySelector('.wrapper').insertAdjacentHTML('beforeend', loader());
        fetch(actionUrl, options)
            .then(response => response.json())
            .then(data => {
                filteredMarkers = allMarkers.filter(marker => data.some(item => item.id === marker.id));
                setMapOnAll(filteredMarkers);

                markerCluster.clearMarkers();
                markerCluster.addMarkers(filteredMarkers);
            }).catch(err => console.warn('error', err)).finally(() => document.querySelector('.lds-roller').remove());
    });


    document.querySelector('.button.clear').addEventListener('click', function () {
        setMapOnAll(allMarkers);
        markerCluster.clearMarkers();
        markerCluster.addMarkers(allMarkers);
    });


    allStationsCloseButton.addEventListener('click', () => {
        allStationsModal.classList.add('hidden');
        allStationsButton.classList.remove('lg-d-none')
        document.querySelector('.modal-container#allstation').style.zIndex = -1;
    })

    stationDetailModalCloseButton.addEventListener('click', () => {
        stationDetailModal.classList.add('hidden');
        document.querySelector('.modal-container#stationdetail').style.zIndex = -1;
        document.querySelector('.modal-container#searchResultModal').style.zIndex = 999999;

        allMarkers.forEach(marker => marker.setIcon({url: marker.getIcon().url, scaledSize: defaultIconSize}))
    })


    var socketTypeButtons = document.querySelectorAll('.radio_type');

    socketTypeButtons.forEach(button => button.addEventListener('click', () => {
        document.querySelectorAll('.filter_socket_type').forEach(label => label.classList.remove('active'));
        document.querySelector('label[for="' + button.id + '"]').classList.add('active');
    }))


    var filterButton = document.querySelector('.filter-button');
    var filterModalCloseButton = document.querySelector('.filter-modal-close')
    var filterModal = document.querySelector('.filter-modal');

    filterButton.addEventListener('click', function () {
        hiddenAllModals();
        filterModal.classList.remove('hidden');
        document.querySelector('.modal-container#filtermodal').style.zIndex = 99999999;
    })

    filterModalCloseButton.addEventListener('click', () => {
        filterModal.classList.add('hidden');
        document.querySelector('.modal-container#filtermodal').style.zIndex = -1;
    })


    const onInput = (parent, e) => {
        const slides = parent.querySelectorAll("input");
        const min = parseFloat(slides[0].min);
        const max = parseFloat(slides[0].max);

        let slide1 = parseFloat(slides[0].value);
        let slide2 = parseFloat(slides[1].value);

        const percentageMin = (slide1 / (max - min)) * 100;
        const percentageMax = (slide2 / (max - min)) * 100;

        parent.style.setProperty("--range-slider-value-low", percentageMin);
        parent.style.setProperty("--range-slider-value-high", percentageMax);

        if (slide1 > slide2) {
            const tmp = slide2;
            slide2 = slide1;
            slide1 = tmp;

            if (e?.currentTarget === slides[0]) {
                slides[0].insertAdjacentElement("beforebegin", slides[1]);
            } else {
                slides[1].insertAdjacentElement("afterend", slides[0]);
            }
        }

        document.querySelectorAll('.active-step').forEach(x => x.classList.add('d-none'));
        if (slide1 != 0 && slide1 != 250) {
            document.querySelector('#kw' + slide1).classList.remove('d-none');
        }
        if (slide2 != 250 && slide2 != 0) {
            document.querySelector('#kw' + slide2).classList.remove('d-none');
        }

        document.querySelectorAll('.charge-speed-box #steps span').forEach(box => box.classList.remove('rounded-box'));
        for (let i = 0; i < 250; i += 50) {
            if (i > slide1 && i < slide2) {
                document.querySelector('#kw' + i).parentElement.classList.add('rounded-box');
            }
        }

        parent
            .querySelector(".range-slider__display")
            .setAttribute("data-low", slide1);
        parent
            .querySelector(".range-slider__display")
            .setAttribute("data-high", slide2);
    };

    document.querySelectorAll(".range-slider").forEach((range) =>
        range.querySelectorAll("input").forEach((input) => {
            if (input.type === "range") {
                input.oninput = (e) => onInput(range, e);
                onInput(range);
            }
        })
    );
    const searchResultModalContainer = document.querySelector('.modal-container#searchResultModal');

    searchInput.addEventListener('input', makeRequest);
    function makeRequest() {
        const inputValue = searchInput.value;
        clearTimeout(timeoutId);

        if (inputValue.length > 3) {
            hiddenAllModals();

            timeoutId = setTimeout(() => {
                const actionUrl = `${url}/map/charge-map?keyword=${encodeURIComponent(inputValue)}`;
                fetch(actionUrl)
                    .then(response => response.json())
                    .then(displayResults);
            }, 300);
        } else {
           clearResults();
        }
    }
    function displayResults(data) {
        clearResults();
        if (data.length > 0) {
            resultsContainer.style.display = 'block';
            data.forEach(result => {
                const stationElement = createStationElement(result);
                resultsContainer.appendChild(stationElement);
                searchResultModalContainer.style.zIndex = 999999;

                stationElement.addEventListener('click', () => {
                    searchResultModalContainer.style.zIndex = -1;

                    targetMarker = allMarkers.find(x => x.id === result.id);
                    map.setCenter(targetMarker.getPosition());
                    map.setZoom(17);

                    document.querySelector('.station-detail-name').innerHTML = result.title;
                    document.querySelector('#detail_address').innerHTML = result.address_line_1 + ' ' + (result.address_line_2 ? result.address_line_2 : '');
                    document.querySelector('#detail_phone').innerHTML = result.contact_telephone_1 ? result.contact_telephone_1 : '-------';
                    const socketTypeContainer = document.querySelector('.station-detail-sockets .sockets .socket-type');
                    socketTypeContainer.innerHTML = '';
                    socketTypeContainer.insertAdjacentHTML('beforeend', stationModalConnections(result.connections, true));
                    hiddenAllModals();

                    stationDetailModal.classList.remove('hidden');
                    document.querySelector('.modal-container#stationdetail').style.zIndex = 9999999;

                    targetMarker.setIcon({url: targetMarker.getIcon().url, scaledSize: enlargedIconSize});
                });
            });
        } else {
            resultsContainer.style.display = 'none';
        }
    }

    function handleClick(result, stationElement) {
        searchResultModalContainer.style.zIndex = -1;
        targetMarker = allMarkers.find(x => x.id === result.id);
        map.setCenter(targetMarker.getPosition());
        map.setZoom(17);

        document.querySelector('.station-detail-name').innerHTML = result.title;
        document.querySelector('#detail_address').innerHTML = result.address_line_1 + ' ' + (result.address_line_2 ? result.address_line_2 : '');
        document.querySelector('#detail_phone').innerHTML = result.contact_telephone_1 ? result.contact_telephone_1 : '-------';
        document.querySelector('.station-detail-sockets .sockets .socket-type').innerHTML = '';
        document.querySelector('.station-detail-sockets .sockets .socket-type').insertAdjacentHTML('beforeend', stationModalConnections(result.connections, true));

        hiddenAllModals();

        stationDetailModal.classList.remove('hidden');
        document.querySelector('.modal-container#stationdetail').style.zIndex = 9999999;

        targetMarker.setIcon({ url: targetMarker.getIcon().url, scaledSize: enlargedIconSize });
    }

    function createStationElement(result) {
        const station =
            `<div class="d-flex align-items-center">
            <img class="stationIcon" src="${markerIcon}" alt="marker">
            <div class="location">
                <div class="location-title">${result.title}</div>
                <div class="location-address">${result.address_line_1} ${result.address_line_2 ? result.address_line_2 : ''}</div>
            </div>
        </div>`;

        const stationElement = document.createElement('div');
        stationElement.classList.add('station');
        stationElement.innerHTML = station;
        stationElement.addEventListener('click', () => handleClick(result, stationElement));

        return stationElement;
    }

    function clearResults() {
        resultsContainer.style.display = "none";
        resultsContainer.innerHTML = '';
    }
})
