<?php

namespace Visiosoft\TogerTheme\Http\Controller;

use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\PostsModule\Post\Contract\PostRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\ConnectModule\Traits\ApiReturnResponseTrait;

class PostController extends PublicController
{
    use ApiReturnResponseTrait;

    protected PostRepositoryInterface $postRepository;
    protected CategoryRepositoryInterface $postCategoryRepository;

    public function __construct(PostRepositoryInterface $postRepository, CategoryRepositoryInterface $categoryRepository)
    {

        $this->postRepository = $postRepository;
        $this->postCategoryRepository = $categoryRepository;
    }

    public function getListByCategory(string $category)
    {
        $posts = [];
        $category = $this->postCategoryRepository->findBy('slug', $category);
        if ($category) {
            $posts = $this->postRepository
                ->newQuery()
                ->where('category_id', $category->getId())
                ->get();
        }

        return $posts;
    }

    public function getFaq(Request $request)
    {
        if (isset($request->header()['locale'])) {
            app()->setLocale($request->header()['locale'][0]);
        }

        $faqs = $this->getListByCategory("faq");
        $formatted = [];
        if ($faqs) {
            $faqs->each(function ($faq, $key) use (&$formatted) {
                $formatted[$key] = ['title' => $faq->title, 'content' => $faq->entry->content];
            });
        }
        return $formatted;
    }

}