<?php namespace Visiosoft\TicketsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\TicketsModule\Bot\BotSeeder;
use Visiosoft\TicketsModule\Department\DepartmentSeeder;
use Visiosoft\TicketsModule\Priority\PrioritySeeder;
use Visiosoft\TicketsModule\Status\StatusSeeder;

class TicketsModuleSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(TemplateRepositoryInterface $templateRepository)
    {
        $this->call(DepartmentSeeder::class);
        $this->call(StatusSeeder::class);
        $this->call(PrioritySeeder::class);
        $this->call(BotSeeder::class);

        $emailTemplates = [
            'ticket_answered_client' => [
                'slug' => 'ticket_answered_client',
                'en' => [
                    'name' => 'Your ticket was answered',
                    'subject' => 'Dear {display_name} your ticket {ticket_number} was answered',
                    'greeting' => 'Hello',
                    'message' => '<p>Dear {display_name}</p><p>Your ticket was answered.</p><p>&nbsp;</p><p>please check your ticket.</p><p>&nbsp;</p><p>Ticket No: {ticket_number}</p><p><br>Ticket Subject: {subject}</p><p>&nbsp;</p><p>If your problem is solved, please close your ticket.</p><p>&nbsp;</p>'
                ],
            ],
            'ticket_answered_admin' => [
                'slug' => 'ticket_answered_admin',
                'en' => [
                    'name' => 'Ticket {ticket_number} was answered',
                    'subject' => 'Ticket {ticket_number} was answered',
                    'greeting' => 'Hello',
                    'message' => '<p>Ticket No: {ticket_number} was answered.<br><br>Subject: {subject}<br><br>Link: {link}</p>'
                ],
            ],
            'new_ticket_opened' => [
                'slug' => 'new_ticket_opened',
                'en' => [
                    'name' => 'Ticket {ticket_number} was opened',
                    'subject' => 'Ticket {ticket_number} was opened',
                    'greeting' => 'Hello',
                    'message' => '<p>Ticket No: {ticket_number} was opened.<br><br>Subject: {subject}</p>'
                ],
            ],
            'ticket_closed_admin' => [
                'slug' => 'ticket_closed_admin',
                'en' => [
                    'name' => 'Ticket {ticket_number} was closed',
                    'subject' => 'Ticket {ticket_number} was closed',
                    'greeting' => 'Hello',
                    'message' => '<p>Ticket No: {ticket_number} was closed.</p><p>Subject: {subject}</p><p>Link: {link}</p>'
                ],
            ],
            'ticket_closed_client' => [
                'slug' => 'ticket_closed_client',
                'en' => [
                    'name' => 'Ticket {ticket_number} was closed',
                    'subject' => 'Dear {display_name} your ticket {ticket_number} was closed',
                    'greeting' => 'Hello',
                    'message' => '<p>Dear {display_name}</p><p>&nbsp;</p><p>Your ticket was closed.</p><p>&nbsp;</p><p>Ticket No: {ticket_number}</p><p>&nbsp;</p><p>Subject: {subject}</p>'
                ],
            ]
        ];
        foreach ($emailTemplates as $key => $template) {
            if (!$templateRepository->findBySlug($key)) {
                $template['enabled'] = true;
                $template['stream'] = null;
                $template['view'] = null;
                $templateRepository->newQuery()->create($template);
            }
        }
    }
}
