<?php

namespace Visiosoft\TicketsModule\Notification;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use NotificationChannels\Discord\DiscordChannel;
use NotificationChannels\Discord\DiscordMessage;

class DiscordNotification extends Notification
{
    use Queueable;

    protected $message, $token;

    public function __construct($message)
    {
        $this->message = $message;
    }


    public function via($notifiable)
    {
        return [DiscordChannel::class];
    }

    public function toDiscord($notifiable)
    {
        return DiscordMessage::create($this->message);
    }
}
