<?php namespace Visiosoft\TicketsModule\Ticket\Form;

use Illuminate\Support\Facades\Auth;
use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorRepositoryInterface;

class ThreadFormFields
{
    public function handle(ThreadFormBuilder $builder, SupervisorRepositoryInterface $supervisorRepository)
    {

        $supervisorOptions = [];
        $supervisors = $supervisorRepository->all();
        $defaultValue = null;
        if (!empty($supervisors)) {
            foreach ($supervisors as $supervisor) {
                $supervisorOptions[$supervisor->id] = $supervisor->name . ' - ' . $supervisor->department->name;
                if ($supervisor->user_id == Auth::id()) {
                    $defaultValue = $supervisor->id;
                }
            }
        }
        $builder->setFields(
            [
                'supervisor_id' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.supervisor.name') . '</strong>',
                    'type' => 'anomaly.field_type.select',
                    'required' => true,
                    'config' => [
                        'options' => $supervisorOptions,
                        'default_value' => $defaultValue
                    ]
                ],
                'content' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.message.name') . '</strong>',
                    'type' => 'anomaly.field_type.wysiwyg',
                    'required' => true
                ],
                'checking' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.check_by_supervisor.name') . '</strong>',
                    'type' => 'anomaly.field_type.boolean',
                ]
            ]
        );
    }
}
