<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedAdminDiscordEvent;

class TicketClosedAdminDiscordListener
{

    public function handle(TicketClosedAdminDiscordEvent $event)
    {
        $ticket = $event->ticket;
        $notificationParams = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'user' => @$ticket->user->name(),
            'subject' => $ticket->subject,
            'supervisor' => @$ticket->supervisor->name,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id
        ];
        $bot = BotModel::where('slug', 'discord_notification_bot')->first();
        $discordMessage = trans('visiosoft.module.tickets::message.ticket_closed_by_admin', $notificationParams);
        $bot->notify(new DiscordNotification($discordMessage));
    }
}