<?php

namespace Visiosoft\TicketsModule\Ticket\Table\Views;

use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Illuminate\Database\Eloquent\Builder;

class Closed extends View
{

    protected $slug = 'closed';

    protected $text = 'visiosoft.module.tickets::view.closed';

    protected $query = AllQuery::class;

    public function onQuerying(Builder $query)
    {
        $query->wherehas('status', function ($status) {
            $status->where('slug', 'closed');
        })->orderBy('updated_at', 'desc');;
    }

}
