<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedEmailEvent;

class TicketClosedAdminEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(TicketClosedEmailEvent $event)
    {
        $person = $event->getPerson();
        $ticket = $event->getTicket();
        $params = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id,
            'subject' => $ticket->subject
        ];
        $template = $this->template->findBySlug('ticket_closed_admin');
        $adminRole = app(RoleRepositoryInterface::class)->findBySlug('admin');
        $admins = $adminRole->getUsers();
        if ($template) {
            Notification::send($admins, new MailTemplate($template->getTemplateForArray($params)));
        }
    }
}
