<?php namespace Visiosoft\TicketsModule\Supervisor;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorInterface;
use Anomaly\Streams\Platform\Model\Tickets\TicketsSupervisorsEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SupervisorModel extends TicketsSupervisorsEntryModel implements SupervisorInterface
{
    use HasFactory;

    /**
     * @return SupervisorFactory
     */
    protected static function newFactory()
    {
        return SupervisorFactory::new();
    }

    public function user() {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}
