<?php namespace Visiosoft\TicketsModule\Ticket\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\AdvsModule\Adv\Table\Views\All;
use Visiosoft\TicketsModule\Ticket\TicketModel;

class TicketTableBuilder extends TableBuilder
{

    protected $model = TicketModel::class;

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'subject', 'ticket_number', 'user',
        'supervisor', 'status', 'department',
        'priority'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'department',
        'ticket_number' => [
            'wrapper' => '<a href="/admin/tickets/detail/{value.ticketNo}" target="_blank"><strong>#{value.ticketNo}</strong></a>',
            'value' => [
                'ticketNo' => 'entry.ticket_number'
            ]
        ],
        'user',
        'supervisor',
        'status' => [
            'wrapper' => '<strong style="color: {value.color}">{value.name}</strong>',
            'value'       => [
                'name'     => 'entry.status.name',
                'color'     => 'entry.status.color',

            ]
        ],
        'priority',
        'updated_at' => [
            'wrapper' => '{{date(entry.updated_at).format("Y F d H:i")}}'
        ]
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit',
        'thread'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
//        'table_view' => 'visiosoft.module.tickets::admin.status.table.table'
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
