<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTicketsCreateSupervisorsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'supervisors',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'user' => [
            'required' => true
        ],
        'department' => [
            'required' => true
        ],
        'signature'
    ];

}
