<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredEmailEvent;

class TicketAnsweredClientEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(TicketAnsweredEmailEvent $event)
    {
        $person = $event->getPerson();
        $ticket = $event->getTicket();
        $params = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'display_name' => $person->display_name,
            'subject' => $ticket->subject
        ];
        $template = $this->template->findBySlug('ticket_answered_client');
        $ticket = BotModel::where('slug', 'discord_notification_bot')->first();
        $notificationParams = $params;
        $notificationParams['link'] = config('app.url') . '/admin/tickets/thread/' . $ticket->id;
        $discordMessage = trans('visiosoft.module.tickets::message.ticket_answered_by_client', $notificationParams);
        $ticket->notify(new DiscordNotification($discordMessage));
        if ($template and $email = $person->email) {
            $person->notify(new MailTemplate($template->getTemplateForArray($params), $email));
        }
    }
}