<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredAdminEvent;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredEmailEvent;

class TicketAnsweredAdminEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(TicketAnsweredAdminEvent $event)
    {
        $ticket = $event->getTicket();
        $params = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id,
            'subject' => $ticket->subject
        ];
        $template = $this->template->findBySlug('ticket_answered_admin');
        $ticket = BotModel::where('slug', 'discord_notification_bot')->first();
        $discordMessage = trans('visiosoft.module.tickets::message.ticket_answered_by_admin', $params);
        $ticket->notify(new DiscordNotification($discordMessage));
        if ($template) {
            Notification::send(get_admins(), new MailTemplate($template->getTemplateForArray($params)));
        }
    }
}