<?php namespace Visiosoft\TicketsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedEmailEvent;
use Visiosoft\TicketsModule\Ticket\Form\ThreadFormBuilder;
use Visiosoft\TicketsModule\Ticket\Form\TicketFormBuilder;
use Visiosoft\TicketsModule\Ticket\Table\TicketTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class TicketsController extends AdminController
{
    protected $ticketRepository;
    public function __construct(TicketRepositoryInterface $ticketRepository)
    {
        $this->ticketRepository = $ticketRepository;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param TicketTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(TicketTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ThreadFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(TicketFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ThreadFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(TicketFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function showThread($id) {
        $ticket = $this->ticketRepository->newQuery()->find($id);
        if (!$ticket) {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => 'Ticket']));
        }
        $ticket = $ticket->toArray();
        return $this->view->make('module::admin.tickets.thread',['ticket' => $ticket]);
    }

    public function close($id, MessageBag $messages) {
        $ticket = $this->ticketRepository->newQuery()->find($id);
        if (!$ticket) {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => 'Ticket']));
        }
        $ticket->update(['status_id' => 4]);
        $person = $ticket->user;
        event(new TicketClosedEmailEvent($person, $ticket));
        $messages->success(trans('module::message.ticket_closed'));
        return redirect()->back();
    }
}
