<?php namespace Visiosoft\TicketsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TicketsModule\Content\Contract\ContentRepositoryInterface;
use Visiosoft\TicketsModule\Content\ContentRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsContentsEntryModel;
use Visiosoft\TicketsModule\Content\ContentModel;
use Visiosoft\TicketsModule\File\Contract\FileRepositoryInterface;
use Visiosoft\TicketsModule\File\FileRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsFilesEntryModel;
use Visiosoft\TicketsModule\File\FileModel;
use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorRepositoryInterface;
use Visiosoft\TicketsModule\Supervisor\SupervisorRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsSupervisorsEntryModel;
use Visiosoft\TicketsModule\Supervisor\SupervisorModel;
use Visiosoft\TicketsModule\Priority\Contract\PriorityRepositoryInterface;
use Visiosoft\TicketsModule\Priority\PriorityRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsPrioritiesEntryModel;
use Visiosoft\TicketsModule\Priority\PriorityModel;
use Visiosoft\TicketsModule\Department\Contract\DepartmentRepositoryInterface;
use Visiosoft\TicketsModule\Department\DepartmentRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsDepartmentsEntryModel;
use Visiosoft\TicketsModule\Department\DepartmentModel;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Form\ThreadFormBuilder;
use Visiosoft\TicketsModule\Ticket\TicketRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsTicketsEntryModel;
use Visiosoft\TicketsModule\Ticket\TicketModel;
use Visiosoft\TicketsModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\TicketsModule\Status\StatusRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsStatusEntryModel;
use Visiosoft\TicketsModule\Status\StatusModel;
use Illuminate\Routing\Router;

class TicketsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/tickets/contents' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@index',
        'admin/tickets/contents/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@create',
        'admin/tickets/contents/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@edit',
        'admin/tickets/files' => 'Visiosoft\TicketsModule\Http\Controller\Admin\FilesController@index',
        'admin/tickets/files/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\FilesController@create',
        'admin/tickets/files/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\FilesController@edit',
        'admin/tickets/supervisors' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@index',
        'admin/tickets/supervisors/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@create',
        'admin/tickets/supervisors/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@edit',
        'admin/tickets/priorities' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@index',
        'admin/tickets/priorities/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@create',
        'admin/tickets/priorities/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@edit',
        'admin/tickets/departments' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@index',
        'admin/tickets/departments/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@create',
        'admin/tickets/departments/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@edit',
        'admin/tickets/tickets' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@index',
        'admin/tickets/tickets/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@create',
        'admin/tickets/tickets/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@edit',
        'admin/tickets/status' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@index',
        'admin/tickets/status/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@create',
        'admin/tickets/status/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@edit',
        'admin/tickets/thread/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@showThread',
        'admin/tickets/close/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@close',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\TicketsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\TicketsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\TicketsModule\Event\ExampleEvent::class => [
        //    Visiosoft\TicketsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\TicketsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TicketsContentsEntryModel::class => ContentModel::class,
        TicketsFilesEntryModel::class => FileModel::class,
        TicketsSupervisorsEntryModel::class => SupervisorModel::class,
        TicketsPrioritiesEntryModel::class => PriorityModel::class,
        TicketsDepartmentsEntryModel::class => DepartmentModel::class,
        TicketsTicketsEntryModel::class => TicketModel::class,
        TicketsStatusEntryModel::class => StatusModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        'supervisor_form' => ThreadFormBuilder::class,
        ContentRepositoryInterface::class => ContentRepository::class,
        FileRepositoryInterface::class => FileRepository::class,
        SupervisorRepositoryInterface::class => SupervisorRepository::class,
        PriorityRepositoryInterface::class => PriorityRepository::class,
        DepartmentRepositoryInterface::class => DepartmentRepository::class,
        TicketRepositoryInterface::class => TicketRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        $router->group(['middleware' => 'auth:api', 'prefix' => 'api'], function ($router) {
            $router->group(['prefix' => 'tickets'], function ($router) {
                $router->get('/auth', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@auth');
                $router->get('/', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@index');
                $router->post('/', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@create');
                $router->put('/answer/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@answer');
                $router->put('/close/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@close');
                $router->get('/references', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@getReferences');
                $router->get('/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@thread');
            });
        });
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
