<?php namespace Visiosoft\TicketsModule\Http\Controller\Admin;

use Visiosoft\TicketsModule\File\Form\FileFormBuilder;
use Visiosoft\TicketsModule\File\Table\FileTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class FilesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param FileTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(FileTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param FileFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(FileFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param FileFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(FileFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
