<?php

namespace Visiosoft\TicketsModule\Ticket\Table\Views;

use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class MyTicket extends View
{

    protected $slug = 'my_tickets';

    protected $text = 'visiosoft.module.tickets::view.my_tickets';

    protected $query = AllQuery::class;

    public function onQuerying(Builder $query)
    {
        $query->wherehas('status', function ($status) {
            $status->where('slug', '!=', 'closed');
        })->whereHas('supervisor', function ($query) {
            $query->where('user_id', Auth::id());
        })
            ->orderBy('updated_at', 'desc');
    }

}
