<?php namespace Visiosoft\TicketsModule\Ticket\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\TicketsModule\Ticket\Table\Views\Closed;
use Visiosoft\TicketsModule\Ticket\Table\Views\MyTicket;
use Visiosoft\TicketsModule\Ticket\Table\Views\Open;
use Visiosoft\TicketsModule\Ticket\TicketModel;

class TicketTableBuilder extends TableBuilder
{

    protected $model = TicketModel::class;

    protected $views = [
        'my_tickets' => [
            'view' => MyTicket::class,
            'slug' => 'my_tickets',
            'text' => 'visiosoft.module.tickets::view.my_tickets'
        ],
        'all' => [
            'view' => Open::class,
            'slug' => 'open',
            'text' => 'visiosoft.module.tickets::view.open'
        ],
        'closed' => [
            'view' => Closed::class,
            'slug' => 'closed',
            'text' => 'visiosoft.module.tickets::view.closed'
        ],
        'trash'
    ];

    protected $filters = [
        'subject',
        'ticket_number',
        'supervisor',
        'status',
        'department',
        'priority',
        'customer_resource'
    ];

    protected $columns = [
        'department',
        'subject',
        'ticket_number' => [
            'wrapper' => '<a href="/admin/tickets/detail/{value.ticketNo}" target="_blank"><strong>#{value.ticketNo}</strong></a>',
            'value' => [
                'ticketNo' => 'entry.ticket_number'
            ]
        ],
        'user',
        'supervisor',
        'status' => [
            'wrapper' => '<strong style="color: {value.color}">{value.name}</strong>',
            'value' => [
                'name' => 'entry.status.name',
                'color' => 'entry.status.color',
            ]
        ],
        'priority',
        'customer_resource',
        'updated_at' => [
            'wrapper' => '{{date(entry.updated_at).format("Y F d H:i")}}'
        ]
    ];

    protected $buttons = [
        'thread', 'edit'
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [];

    protected $assets = [];

}
