<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\NewTicketEmailEvent;

class NewTicketEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(NewTicketEmailEvent $event)
    {
        $template = $this->template->findBySlug('new_ticket_opened');
        $ticket = $event->getTicket();
        $mail_params = [
            'ticket_number' => $ticket->ticket_number,
            'subject' => $ticket->subject
        ];
        $adminRole = app(RoleRepositoryInterface::class)->findBySlug('admin');
        $admins = $adminRole->getUsers();
        if ($template) {
            Notification::send($admins, new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}