<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTicketsFieldType extends Migration
{

    public function up()
    {
        $userField = $this->fields()->findBySlugAndNamespace('user', 'tickets');

        $userField->config = [
            'mode' => 'lookup',
            'related' => 'Anomaly\UsersModule\User\UserModel',
        ];
        $closedByField = $this->fields()->findBySlugAndNamespace('closed_by', 'tickets');

        $closedByField->config = [
            'mode' => 'lookup',
            'related' => 'Anomaly\UsersModule\User\UserModel',
        ];

        $userField->save();
        $closedByField->save();

        $field = $this->fields()->findBySlugAndNamespace('message', "tickets");
        $field->setAttribute('type', 'anomaly.field_type.textarea');
        $field->save();
    }
}
