<?php namespace Visiosoft\TicketsModule\Ticket\Form;

use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorRepositoryInterface;

class ThreadFormFields
{
    public function handle(ThreadFormBuilder $builder, SupervisorRepositoryInterface $supervisorRepository)
    {

        $supervisorOptions = [];
        $supervisors = $supervisorRepository->all();
        if (!empty($supervisors)) {
            foreach ($supervisors as $supervisor) {
                $supervisorOptions[$supervisor->id] = $supervisor->name . ' - ' . $supervisor->department->name;
            }
        }
        $builder->setFields(
            [
                'supervisor_id' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.supervisor.name') . '</strong>',
                    'type' => 'anomaly.field_type.select',
                    'required' => true,
                    'config' => [
                        'options' => $supervisorOptions
                    ]
                ],
                'content' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.message.name') . '</strong>',
                    'type' => 'anomaly.field_type.wysiwyg',
                    'required' => true
                ],
                'checking' => [
                    'label' => '<strong>' . trans('visiosoft.module.tickets::field.check_by_supervisor.name') . '</strong>',
                    'type' => 'anomaly.field_type.boolean',
                ]
            ]
        );
    }
}
