<?php namespace Visiosoft\TicketsModule\Ticket\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\TicketsModule\Content\Contract\ContentRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredAdminDiscordEvent;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredAdminEvent;

class ThreadFormHandler
{
    public function handle(ThreadFormBuilder $builder, MessageBag $messages)
    {

        $inputs = request()->all();
        $ticketRepository = app(TicketRepositoryInterface::class);
        $contentRepository = app(ContentRepositoryInterface::class);
        $ticket = $ticketRepository->find($inputs['ticket_id']);
        if (!$ticket) {
            $messages->error(trans('visiosoft.module.connect::message.not_found', ['name' => 'Ticket']));
            return redirect()->back();
        }
        $contentRepository->create([
            'ticket_id' => $ticket->id,
            'message' => $this->replaceImageLink($inputs['content']),
            'supervisor_id' => $inputs['supervisor_id'],
        ]);
        if (!empty($inputs['checking'])) {
            $ticket->update(['status_id' => 2, 'supervisor_id' => $inputs['supervisor_id']]);
        } else {
            $ticket->update(['status_id' => 3, 'supervisor_id' => $inputs['supervisor_id']]);
        }
        $person = $ticket->user;
        if (setting_value('visiosoft.module.tickets::send_email_notification')) {
            event(new TicketAnsweredAdminEvent($person, $ticket));
        }
        if (setting_value('visiosoft.module.tickets::send_discord_notification')) {
            event(new TicketAnsweredAdminDiscordEvent($ticket));
        }
        $messages->success(trans('module::message.message_sent'));
        return redirect()->back();
    }

    private function replaceImageLink($content){
        $baseUrl = rtrim(url(''), '/') . '/';
        $pattern = '/<img\s+([^>]*\s+)?src=("|\')\/(.*?)("|\')/';
        $content = preg_replace_callback($pattern, function ($match) use ($baseUrl) {
            $src = $match[3];
            // Build the new src attribute with the base URL
            return '<img ' . $match[1] . 'src="' . $baseUrl . $src . '"' . $match[4];
        }, $content);

        return $content;
    }
}
