<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTicketsCreateTicketsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'tickets',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subject',
        'closed_at',
        'closed_by',
        'priority',
        'supervisor',
        'user' => [
            'required' => true
        ],
        'department' => [
            'required' => true
        ],
        'status' => [
            'required' => true
        ],
        'ticket_number' => [
            'required' => true
        ],
        'email' => [
            'required' => true
        ],
        'name' => [
            'required' => true
        ]
    ];

}
