<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTicketsCreateTicketsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class,
                'mode' => 'lookup'
            ],
        ],
        'ticket_number' => [
            'type' => 'anomaly.field_type.text',
        ],
        'status' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Status\StatusModel::class
            ]
        ],
        'department' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Department\DepartmentModel::class
            ]
        ],
        'priority' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Priority\PriorityModel::class
            ]
        ],
        'supervisor' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Supervisor\SupervisorModel::class,
            ],
        ],
        'content' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Content\ContentModel::class
            ]
        ],
        'ticket' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\TicketsModule\Ticket\TicketModel::class,
                'mode' => 'lookup'
            ]
        ],
        'subject' => [
            'type' => 'anomaly.field_type.text'
        ],
        'message' => [
            'type' => 'anomaly.field_type.text'
        ],
        'color' => [
            'type' => 'anomaly.field_type.colorpicker'
        ],
        'file' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\FilesModule\File\FileModel::class
            ]
        ],
        'closed_at' => [
            'type' => 'anomaly.field_type.datetime'
        ],
        'closed_by' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class,
            ],
        ],
        'signature' => [
            'type' => 'anomaly.field_type.editor',
        ],
        'email' => [
            'type' => 'anomaly.field_type.text',
        ]
    ];

}
