<?php namespace Visiosoft\TicketsModule\Ticket;

use phpseclib3\Math\PrimeField\Integer;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TicketRepository extends EntryRepository implements TicketRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TicketModel
     */
    protected $model;

    /**
     * Create a new TicketRepository instance.
     *
     * @param TicketModel $model
     */
    public function __construct(TicketModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param Integer $id
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Eloquent\Model|null
     */
    public function getTicketThreadById(int $id)
    {
        return $this->model->with(['supervisor', 'department', 'status', 'user', 'contents'])->find($id);
    }

    /**
     * @return int
     */
    public function getTicketNumber(): int
    {
        $ticketNumber = 2122;
        $last = $this->model->orderBy('ticket_number', 'DESC')->first();
        if (!empty($last)) {
            $ticketNumber = $last->ticket_number + 1;
        }
        return $ticketNumber;
    }
}
