<?php namespace Visiosoft\TicketsModule\Ticket\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\AdvsModule\Adv\Table\Views\All;
use Visiosoft\TicketsModule\Ticket\TicketModel;

class TicketTableBuilder extends TableBuilder
{

    protected $model = TicketModel::class;

    public function onQuerying(Builder $query)
    {
        $query->orderBy("id", 'DESC');
    }

    protected $views = [];

    protected $filters = [
        'subject', 'ticket_number', 'user',
        'supervisor', 'status', 'department',
        'priority'
    ];

    protected $columns = [
        'department',
        'ticket_number' => [
            'wrapper' => '<a href="/admin/tickets/detail/{value.ticketNo}" target="_blank"><strong>#{value.ticketNo}</strong></a>',
            'value' => [
                'ticketNo' => 'entry.ticket_number'
            ]
        ],
        'user',
        'supervisor',
        'status' => [
            'wrapper' => '<strong style="color: {value.color}">{value.name}</strong>',
            'value' => [
                'name' => 'entry.status.name',
                'color' => 'entry.status.color',

            ]
        ],
        'priority',
        'updated_at' => [
            'wrapper' => '{{date(entry.updated_at).format("Y F d H:i")}}'
        ]
    ];

    protected $buttons = [
        'thread'
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
//        'table_view' => 'visiosoft.module.tickets::admin.status.table.table'
    ];

    protected $assets = [];

}
