<?php namespace Visiosoft\TicketsModule\Http\Controller\Admin;

use Visiosoft\TicketsModule\Content\Form\ContentFormBuilder;
use Visiosoft\TicketsModule\Content\Table\ContentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ContentsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ContentTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ContentTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ContentFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ContentFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ContentFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ContentFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
