<?php namespace Visiosoft\TicketsModule\Status;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\TicketsModule\Status\Contract\StatusRepositoryInterface;

class StatusSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        $statuses = [
            [
                'en' => [
                    'name' => 'Waiting for an answer'
                ],
                'slug' => 'waiting',
                'color' => '#E0CB32'
            ],
            [
                'en' => [
                    'name' => 'Checking by an expert'
                ],
                'slug' => 'checking',
                'color' => '#31A0E0'
            ],
            [
                'en' => [
                    'name' => 'Answered'
                ],
                'slug' => 'answered',
                'color' => '#44E05C'
            ],
            [
                'en' => [
                    'name' => 'Closed'
                ],
                'slug' => 'closed',
                'color' => '#E04128'
            ]
        ];
        $statusRepository = app(StatusRepositoryInterface::class);
        foreach ($statuses as $status) {
            if (!$statusRepository->newQuery()->where('slug', $status['slug'])->orderBy('id', 'asc')->first()) {
                $statusRepository->create($status);
            }
        }
    }
}
