<?php namespace Visiosoft\TicketsModule\Department;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\TicketsModule\Department\Contract\DepartmentRepositoryInterface;

class DepartmentSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        $a = 'aaaaa';
        $departments = [
            [
                'en' => [
                    'name' => 'Sales'
                ],
                'slug' => 'sales'
            ],
            [
                'en' => [
                    'name' => 'Technical Support'
                ],
                'slug' => 'technical_support'
            ],
            [
                'en' => [
                    'name' => 'Accounting'
                ],
                'slug' => 'accounting'
            ]
        ];
        $departmentRepository = app(DepartmentRepositoryInterface::class);
        foreach ($departments as $department) {
            if (!$departmentRepository->newQuery()->where('slug', $department['slug'])->whereNull('deleted_at')->orderBy('id', 'asc')->first()) {
                $departmentRepository->create($department);
            }
        }
    }
}
