<?php namespace Visiosoft\TicketsModule\Content;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\TicketsModule\Content\Contract\ContentInterface;
use Anomaly\Streams\Platform\Model\Tickets\TicketsContentsEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Visiosoft\TicketsModule\Supervisor\SupervisorModel;

class ContentModel extends TicketsContentsEntryModel implements ContentInterface
{
    use HasFactory;

    /**
     * @return ContentFactory
     */
    protected static function newFactory()
    {
        return ContentFactory::new();
    }

    protected $appends = [
        'user',
        'supervisor',
        'created',
        'updated'
    ];

    public function getCreatedAttribute()
    {
        return $this->created_at->format('Y-m-d H:i:s');
    }

    public function getUpdatedAttribute()
    {
        return $this->created_at->format('Y-m-d H:i:s');
    }

    public function getUserAttribute()
    {
        return $this->user()->first();
    }

    public function getSupervisorAttribute()
    {
        return $this->supervisor()->first();
    }

    public function supervisor()
    {
        return $this->belongsTo(SupervisorModel::class, 'supervisor_id');
    }

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}
