<?php namespace Visiosoft\TicketsModule\Ticket\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\TicketsModule\Content\Contract\ContentRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredAdminEvent;

class ThreadFormHandler
{
    public function handle(ThreadFormBuilder $builder, MessageBag $messages)
    {

        $inputs = request()->all();
        $ticketRepository = app(TicketRepositoryInterface::class);
        $contentRepository = app(ContentRepositoryInterface::class);
        $ticket = $ticketRepository->find($inputs['ticket_id']);
        if (!$ticket) {
            $messages->error(trans('visiosoft.module.connect::message.not_found', ['name' => 'Ticket']));
            return redirect()->back();
        }
        $contentRepository->create([
            'ticket_id' => $ticket->id,
            'message' => $inputs['content'],
            'supervisor_id' => $inputs['supervisor_id'],
        ]);
        if (!empty($inputs['checking'])) {
            $ticket->update(['status_id' => 2, 'supervisor_id' => $inputs['supervisor_id']]);
        } else {
            $ticket->update(['status_id' => 3, 'supervisor_id' => $inputs['supervisor_id']]);
        }
        $person = $ticket->user;
        event(new TicketAnsweredAdminEvent($person, $ticket));
        $messages->success(trans('module::message.message_sent'));
        return redirect()->back();
    }
}
