<?php namespace Visiosoft\TicketsModule\Ticket;

use Anomaly\UsersModule\User\UserModel;
use Illuminate\Notifications\Notifiable;
use Visiosoft\TicketsModule\Content\ContentModel;
use Visiosoft\TicketsModule\Department\DepartmentModel;
use Visiosoft\TicketsModule\Priority\PriorityModel;
use Visiosoft\TicketsModule\Status\StatusModel;
use Visiosoft\TicketsModule\Supervisor\SupervisorModel;
use Visiosoft\TicketsModule\Ticket\Contract\TicketInterface;
use Anomaly\Streams\Platform\Model\Tickets\TicketsTicketsEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TicketModel extends TicketsTicketsEntryModel implements TicketInterface
{
    use HasFactory;

    protected $appends = [
        'status', 'updated', 'created', 'contents',
        'supervisor', 'user', 'department', 'priority'
    ];

    public function getPriorityAttribute()
    {
        return $this->priority()->first();
    }

    public function getUserAttribute()
    {
        return $this->user()->first();
    }

    public function getDepartmentAttribute()
    {
        return $this->department()->first();
    }

    public function getSupervisorAttribute()
    {
        return $this->supervisor()->first();
    }

    public function getContentsAttribute()
    {
        return $this->contents()->orderBy('created_at', 'desc')->get();
    }

    public function getStatusAttribute()
    {
        return $this->status()->first();
    }

    public function getUpdatedAttribute()
    {
        return $this->updated_at->format('Y-m-d H:i:s');
    }

    public function getCreatedAttribute()
    {
        return $this->created_at->format('Y-m-d H:i:s');
    }

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }

    public function status()
    {
        return $this->belongsTo(StatusModel::class, 'status_id');
    }

    public function department()
    {
        return $this->belongsTo(DepartmentModel::class, 'department_id');
    }

    public function supervisor()
    {
        return $this->belongsTo(SupervisorModel::class, 'supervisor_id');
    }

    public function priority()
    {
        return $this->belongsTo(PriorityModel::class, 'priority_id');
    }

    public function contents()
    {
        return $this->hasMany(ContentModel::class, 'ticket_id');
    }
}
